/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.function.IntPredicate;

public abstract class AbstractCharacterFilterReader
extends FilterReader {
    protected static final IntPredicate SKIP_NONE = ch -> false;
    private final IntPredicate skip;

    protected AbstractCharacterFilterReader(Reader reader) {
        this(reader, SKIP_NONE);
    }

    protected AbstractCharacterFilterReader(Reader reader, IntPredicate skip2) {
        super(reader);
        this.skip = skip2 == null ? SKIP_NONE : skip2;
    }

    protected boolean filter(int ch) {
        return this.skip.test(ch);
    }

    @Override
    public int read() throws IOException {
        int ch;
        while ((ch = this.in.read()) != -1 && this.filter(ch)) {
        }
        return ch;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int read2 = super.read(cbuf, off, len);
        if (read2 == -1) {
            return -1;
        }
        int pos2 = off - 1;
        for (int readPos = off; readPos < off + read2; ++readPos) {
            if (this.filter(cbuf[readPos]) || ++pos2 >= readPos) continue;
            cbuf[pos2] = cbuf[readPos];
        }
        return pos2 - off + 1;
    }
}

