/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input.buffer;

import java.util.Objects;
import org.apache.commons.io.IOUtils;

public class CircularByteBuffer {
    private final byte[] buffer;
    private int startOffset;
    private int endOffset;
    private int currentNumberOfBytes;

    public CircularByteBuffer() {
        this(8192);
    }

    public CircularByteBuffer(int size2) {
        this.buffer = IOUtils.byteArray(size2);
        this.startOffset = 0;
        this.endOffset = 0;
        this.currentNumberOfBytes = 0;
    }

    public void add(byte value2) {
        if (this.currentNumberOfBytes >= this.buffer.length) {
            throw new IllegalStateException("No space available");
        }
        this.buffer[this.endOffset] = value2;
        ++this.currentNumberOfBytes;
        if (++this.endOffset == this.buffer.length) {
            this.endOffset = 0;
        }
    }

    public void add(byte[] targetBuffer, int offset2, int length2) {
        Objects.requireNonNull(targetBuffer, "Buffer");
        if (offset2 < 0 || offset2 >= targetBuffer.length) {
            throw new IllegalArgumentException("Illegal offset: " + offset2);
        }
        if (length2 < 0) {
            throw new IllegalArgumentException("Illegal length: " + length2);
        }
        if (this.currentNumberOfBytes + length2 > this.buffer.length) {
            throw new IllegalStateException("No space available");
        }
        for (int i2 = 0; i2 < length2; ++i2) {
            this.buffer[this.endOffset] = targetBuffer[offset2 + i2];
            if (++this.endOffset != this.buffer.length) continue;
            this.endOffset = 0;
        }
        this.currentNumberOfBytes += length2;
    }

    public void clear() {
        this.startOffset = 0;
        this.endOffset = 0;
        this.currentNumberOfBytes = 0;
    }

    public int getCurrentNumberOfBytes() {
        return this.currentNumberOfBytes;
    }

    public int getSpace() {
        return this.buffer.length - this.currentNumberOfBytes;
    }

    public boolean hasBytes() {
        return this.currentNumberOfBytes > 0;
    }

    public boolean hasSpace() {
        return this.currentNumberOfBytes < this.buffer.length;
    }

    public boolean hasSpace(int count2) {
        return this.currentNumberOfBytes + count2 <= this.buffer.length;
    }

    public boolean peek(byte[] sourceBuffer, int offset2, int length2) {
        Objects.requireNonNull(sourceBuffer, "Buffer");
        if (offset2 < 0 || offset2 >= sourceBuffer.length) {
            throw new IllegalArgumentException("Illegal offset: " + offset2);
        }
        if (length2 < 0 || length2 > this.buffer.length) {
            throw new IllegalArgumentException("Illegal length: " + length2);
        }
        if (length2 < this.currentNumberOfBytes) {
            return false;
        }
        int localOffset = this.startOffset;
        for (int i2 = 0; i2 < length2; ++i2) {
            if (this.buffer[localOffset] != sourceBuffer[i2 + offset2]) {
                return false;
            }
            if (++localOffset != this.buffer.length) continue;
            localOffset = 0;
        }
        return true;
    }

    public byte read() {
        if (this.currentNumberOfBytes <= 0) {
            throw new IllegalStateException("No bytes available.");
        }
        byte b = this.buffer[this.startOffset];
        --this.currentNumberOfBytes;
        if (++this.startOffset == this.buffer.length) {
            this.startOffset = 0;
        }
        return b;
    }

    public void read(byte[] targetBuffer, int targetOffset, int length2) {
        Objects.requireNonNull(targetBuffer, "targetBuffer");
        if (targetOffset < 0 || targetOffset >= targetBuffer.length) {
            throw new IllegalArgumentException("Illegal offset: " + targetOffset);
        }
        if (length2 < 0 || length2 > this.buffer.length) {
            throw new IllegalArgumentException("Illegal length: " + length2);
        }
        if (targetOffset + length2 > targetBuffer.length) {
            throw new IllegalArgumentException("The supplied byte array contains only " + targetBuffer.length + " bytes, but offset, and length would require " + (targetOffset + length2 - 1));
        }
        if (this.currentNumberOfBytes < length2) {
            throw new IllegalStateException("Currently, there are only " + this.currentNumberOfBytes + "in the buffer, not " + length2);
        }
        int offset2 = targetOffset;
        for (int i2 = 0; i2 < length2; ++i2) {
            targetBuffer[offset2++] = this.buffer[this.startOffset];
            --this.currentNumberOfBytes;
            if (++this.startOffset != this.buffer.length) continue;
            this.startOffset = 0;
        }
    }
}

