/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.util.KeyValue;

public class SequencedHashMap
implements Map,
Cloneable,
Externalizable {
    private Entry sentinel = SequencedHashMap.createSentinel();
    private HashMap entries;
    private transient long modCount = 0L;
    private static final int KEY = 0;
    private static final int VALUE = 1;
    private static final int ENTRY = 2;
    private static final int REMOVED_MASK = Integer.MIN_VALUE;
    private static final long serialVersionUID = 3380552487888102930L;

    private static Entry createSentinel() {
        Entry s2;
        s2.prev = s2 = new Entry(null, null);
        s2.next = s2;
        return s2;
    }

    public SequencedHashMap() {
        this.entries = new HashMap();
    }

    public SequencedHashMap(int initialSize) {
        this.entries = new HashMap(initialSize);
    }

    public SequencedHashMap(int initialSize, float loadFactor) {
        this.entries = new HashMap(initialSize, loadFactor);
    }

    public SequencedHashMap(Map m) {
        this();
        this.putAll(m);
    }

    private void removeEntry(Entry entry) {
        entry.next.prev = entry.prev;
        entry.prev.next = entry.next;
    }

    private void insertEntry(Entry entry) {
        entry.next = this.sentinel;
        entry.prev = this.sentinel.prev;
        this.sentinel.prev.next = entry;
        this.sentinel.prev = entry;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.sentinel.next == this.sentinel;
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.entries.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        if (value2 == null) {
            Entry pos2 = this.sentinel.next;
            while (pos2 != this.sentinel) {
                if (pos2.getValue() == null) {
                    return true;
                }
                pos2 = pos2.next;
            }
        } else {
            Entry pos3 = this.sentinel.next;
            while (pos3 != this.sentinel) {
                if (value2.equals(pos3.getValue())) {
                    return true;
                }
                pos3 = pos3.next;
            }
        }
        return false;
    }

    public Object get(Object o) {
        Entry entry = (Entry)this.entries.get(o);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Map.Entry getFirst() {
        return this.isEmpty() ? null : this.sentinel.next;
    }

    public Object getFirstKey() {
        return this.sentinel.next.getKey();
    }

    public Object getFirstValue() {
        return this.sentinel.next.getValue();
    }

    public Map.Entry getLast() {
        return this.isEmpty() ? null : this.sentinel.prev;
    }

    public Object getLastKey() {
        return this.sentinel.prev.getKey();
    }

    public Object getLastValue() {
        return this.sentinel.prev.getValue();
    }

    public Object put(Object key2, Object value2) {
        ++this.modCount;
        Object oldValue = null;
        Entry e = (Entry)this.entries.get(key2);
        if (e != null) {
            this.removeEntry(e);
            oldValue = e.setValue(value2);
        } else {
            e = new Entry(key2, value2);
            this.entries.put(key2, e);
        }
        this.insertEntry(e);
        return oldValue;
    }

    public Object remove(Object key2) {
        Entry e = this.removeImpl(key2);
        return e == null ? null : e.getValue();
    }

    private Entry removeImpl(Object key2) {
        Entry e = (Entry)this.entries.remove(key2);
        if (e == null) {
            return null;
        }
        ++this.modCount;
        this.removeEntry(e);
        return e;
    }

    public void putAll(Map t) {
        for (Map.Entry entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.entries.clear();
        this.sentinel.next = this.sentinel;
        this.sentinel.prev = this.sentinel;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        return this.entrySet().equals(((Map)obj).entrySet());
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        Entry pos2 = this.sentinel.next;
        while (pos2 != this.sentinel) {
            buf.append(pos2.getKey());
            buf.append('=');
            buf.append(pos2.getValue());
            if (pos2.next != this.sentinel) {
                buf.append(',');
            }
            pos2 = pos2.next;
        }
        buf.append(']');
        return buf.toString();
    }

    public Set keySet() {
        return new AbstractSet(){

            @Override
            public Iterator iterator() {
                return new OrderedIterator(0);
            }

            @Override
            public boolean remove(Object o) {
                Entry e = SequencedHashMap.this.removeImpl(o);
                return e != null;
            }

            @Override
            public void clear() {
                SequencedHashMap.this.clear();
            }

            @Override
            public int size() {
                return SequencedHashMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return SequencedHashMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return SequencedHashMap.this.containsKey(o);
            }
        };
    }

    public Collection values() {
        return new AbstractCollection(){

            @Override
            public Iterator iterator() {
                return new OrderedIterator(1);
            }

            @Override
            public boolean remove(Object value2) {
                if (value2 == null) {
                    Entry pos2 = ((SequencedHashMap)SequencedHashMap.this).sentinel.next;
                    while (pos2 != SequencedHashMap.this.sentinel) {
                        if (pos2.getValue() == null) {
                            SequencedHashMap.this.removeImpl(pos2.getKey());
                            return true;
                        }
                        pos2 = pos2.next;
                    }
                } else {
                    Entry pos3 = ((SequencedHashMap)SequencedHashMap.this).sentinel.next;
                    while (pos3 != SequencedHashMap.this.sentinel) {
                        if (value2.equals(pos3.getValue())) {
                            SequencedHashMap.this.removeImpl(pos3.getKey());
                            return true;
                        }
                        pos3 = pos3.next;
                    }
                }
                return false;
            }

            @Override
            public void clear() {
                SequencedHashMap.this.clear();
            }

            @Override
            public int size() {
                return SequencedHashMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return SequencedHashMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return SequencedHashMap.this.containsValue(o);
            }
        };
    }

    public Set entrySet() {
        return new AbstractSet(){

            private Entry findEntry(Object o) {
                if (o == null) {
                    return null;
                }
                if (!(o instanceof Map.Entry)) {
                    return null;
                }
                Map.Entry e = (Map.Entry)o;
                Entry entry = (Entry)SequencedHashMap.this.entries.get(e.getKey());
                if (entry != null && entry.equals(e)) {
                    return entry;
                }
                return null;
            }

            @Override
            public Iterator iterator() {
                return new OrderedIterator(2);
            }

            @Override
            public boolean remove(Object o) {
                Entry e = this.findEntry(o);
                if (e == null) {
                    return false;
                }
                return SequencedHashMap.this.removeImpl(e.getKey()) != null;
            }

            @Override
            public void clear() {
                SequencedHashMap.this.clear();
            }

            @Override
            public int size() {
                return SequencedHashMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return SequencedHashMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return this.findEntry(o) != null;
            }
        };
    }

    public Object clone() throws CloneNotSupportedException {
        SequencedHashMap map = (SequencedHashMap)super.clone();
        map.sentinel = SequencedHashMap.createSentinel();
        map.entries = new HashMap();
        map.putAll((Map)this);
        return map;
    }

    private Map.Entry getEntry(int index2) {
        int i2;
        Entry pos2 = this.sentinel;
        if (index2 < 0) {
            throw new ArrayIndexOutOfBoundsException(I18n.err((I18n)I18n.ERR_04427, (Object[])new Object[]{index2}));
        }
        for (i2 = -1; i2 < index2 - 1 && pos2.next != this.sentinel; ++i2) {
            pos2 = pos2.next;
        }
        if (pos2.next == this.sentinel) {
            throw new ArrayIndexOutOfBoundsException(I18n.err((I18n)I18n.ERR_04428, (Object[])new Object[]{index2, i2 + 1}));
        }
        return pos2.next;
    }

    public Object get(int index2) {
        return this.getEntry(index2).getKey();
    }

    public Object getValue(int index2) {
        return this.getEntry(index2).getValue();
    }

    public int indexOf(Object key2) {
        Entry e = (Entry)this.entries.get(key2);
        if (e == null) {
            return -1;
        }
        int pos2 = 0;
        while (e.prev != this.sentinel) {
            ++pos2;
            e = e.prev;
        }
        return pos2;
    }

    public Iterator iterator() {
        return this.keySet().iterator();
    }

    public int lastIndexOf(Object key2) {
        return this.indexOf(key2);
    }

    public List sequence() {
        ArrayList l = new ArrayList(this.size());
        Iterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            l.add(iter.next());
        }
        return Collections.unmodifiableList(l);
    }

    public Object remove(int index2) {
        return this.remove(this.get(index2));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        for (int i2 = 0; i2 < size2; ++i2) {
            Object key2 = in.readObject();
            Object value2 = in.readObject();
            this.put(key2, value2);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        Entry pos2 = this.sentinel.next;
        while (pos2 != this.sentinel) {
            out.writeObject(pos2.getKey());
            out.writeObject(pos2.getValue());
            pos2 = pos2.next;
        }
    }

    private class OrderedIterator
    implements Iterator {
        private int returnType;
        private Entry pos;
        private transient long expectedModCount;

        public OrderedIterator(int returnType) {
            this.pos = SequencedHashMap.this.sentinel;
            this.expectedModCount = SequencedHashMap.this.modCount;
            this.returnType = returnType | Integer.MIN_VALUE;
        }

        @Override
        public boolean hasNext() {
            return this.pos.next != SequencedHashMap.this.sentinel;
        }

        public Object next() {
            if (SequencedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.pos.next == SequencedHashMap.this.sentinel) {
                throw new NoSuchElementException();
            }
            this.returnType &= Integer.MAX_VALUE;
            this.pos = this.pos.next;
            switch (this.returnType) {
                case 0: {
                    return this.pos.getKey();
                }
                case 1: {
                    return this.pos.getValue();
                }
                case 2: {
                    return this.pos;
                }
            }
            throw new Error(I18n.err((I18n)I18n.ERR_04425, (Object[])new Object[]{this.returnType}));
        }

        @Override
        public void remove() {
            if ((this.returnType & Integer.MIN_VALUE) != 0) {
                throw new IllegalStateException(I18n.err((I18n)I18n.ERR_04426, (Object[])new Object[0]));
            }
            if (SequencedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            SequencedHashMap.this.removeImpl(this.pos.getKey());
            ++this.expectedModCount;
            this.returnType |= Integer.MIN_VALUE;
        }
    }

    private static class Entry
    implements Map.Entry,
    KeyValue {
        private final Object key;
        private Object value;
        Entry next = null;
        Entry prev = null;

        public Entry(Object key2, Object value2) {
            this.key = key2;
            this.value = value2;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value2) {
            Object oldValue = this.value;
            this.value = value2;
            return oldValue;
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)obj;
            return (this.getKey() == null ? other.getKey() == null : this.getKey().equals(other.getKey())) && (this.getValue() == null ? other.getValue() == null : this.getValue().equals(other.getValue()));
        }

        public String toString() {
            return "[" + this.getKey() + "=" + this.getValue() + "]";
        }
    }
}

