/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.components;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.asn1.AbstractAsn1Object;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypedData
extends AbstractAsn1Object {
    private List<TD> typedDataList = new ArrayList<TD>();
    private TD currentTD;
    private static final Logger LOG = LoggerFactory.getLogger(TypedData.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private int[] dataTypeTagLength;
    private int[] dataValueTagLength;
    private int[] typedDataSeqLength;
    private int typedDataSeqSeqLength;

    public int getCurrentDataType() {
        return this.currentTD.dataType;
    }

    public void setCurrentDataType(int tdType) {
        this.currentTD.dataType = tdType;
    }

    public byte[] getCurrentDataValue() {
        return this.currentTD.dataValue;
    }

    public void setCurrentDataValue(byte[] tdData) {
        TD.access$102(this.currentTD, tdData);
    }

    public TD getCurrentTD() {
        return this.currentTD;
    }

    public void createNewTD() {
        this.currentTD = new TD();
        this.typedDataList.add(this.currentTD);
    }

    public List<TD> getTypedData() {
        return this.typedDataList;
    }

    @Override
    public int computeLength() {
        int i2 = 0;
        this.typedDataSeqLength = new int[this.typedDataList.size()];
        this.dataTypeTagLength = new int[this.typedDataList.size()];
        this.dataValueTagLength = new int[this.typedDataList.size()];
        this.typedDataSeqSeqLength = 0;
        for (TD td : this.typedDataList) {
            int adTypeLen = BerValue.getNbBytes((int)td.dataType);
            this.dataTypeTagLength[i2] = 1 + TLV.getNbBytes((int)adTypeLen) + adTypeLen;
            this.typedDataSeqLength[i2] = 1 + TLV.getNbBytes((int)this.dataTypeTagLength[i2]) + this.dataTypeTagLength[i2];
            if (td.dataValue != null) {
                this.dataValueTagLength[i2] = 1 + TLV.getNbBytes((int)td.dataValue.length) + td.dataValue.length;
                int n = i2;
                this.typedDataSeqLength[n] = this.typedDataSeqLength[n] + (1 + TLV.getNbBytes((int)this.dataValueTagLength[i2]) + this.dataValueTagLength[i2]);
            }
            this.typedDataSeqSeqLength += 1 + TLV.getNbBytes((int)this.typedDataSeqLength[i2]) + this.typedDataSeqLength[i2];
            ++i2;
        }
        return 1 + TLV.getNbBytes((int)this.typedDataSeqSeqLength) + this.typedDataSeqSeqLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_148, new Object[0]));
        }
        try {
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes((int)this.typedDataSeqSeqLength));
            int i2 = 0;
            for (TD td : this.typedDataList) {
                buffer.put(UniversalTag.SEQUENCE.getValue());
                buffer.put(TLV.getBytes((int)this.typedDataSeqLength[i2]));
                buffer.put((byte)-96);
                buffer.put(TLV.getBytes((int)this.dataTypeTagLength[i2]));
                BerValue.encode((ByteBuffer)buffer, (int)td.dataType);
                if (td.dataValue != null) {
                    buffer.put((byte)-95);
                    buffer.put(TLV.getBytes((int)this.dataValueTagLength[i2]));
                    BerValue.encode((ByteBuffer)buffer, (byte[])td.dataValue);
                }
                ++i2;
            }
        }
        catch (BufferOverflowException boe) {
            LOG.error(I18n.err(I18n.ERR_743_CANNOT_ENCODE_TYPED_DATA, 1 + TLV.getNbBytes((int)this.typedDataSeqSeqLength) + this.typedDataSeqSeqLength, buffer.capacity()));
            throw new EncoderException(I18n.err(I18n.ERR_138, new Object[0]));
        }
        if (IS_DEBUG) {
            LOG.debug("TypedData encoding : {}", (Object)Strings.dumpBytes(buffer.array()));
            LOG.debug("TypedData initial value : {}", (Object)this.toString());
        }
        return buffer;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("TypedData : \n");
        for (TD td : this.typedDataList) {
            sb.append(tabs).append("    {\n");
            sb.append(tabs).append("        tdType: ").append(td.dataType).append('\n');
            if (td.dataValue != null) {
                sb.append(tabs).append("        tdData: ").append(Strings.dumpBytes(td.dataValue)).append('\n');
            }
            sb.append(tabs).append("    }\n");
        }
        return sb.toString();
    }

    public class TD {
        private int dataType;
        private byte[] dataValue;

        public int getDataType() {
            return this.dataType;
        }

        public byte[] getDataValue() {
            return this.dataValue;
        }

        static /* synthetic */ byte[] access$102(TD x0, byte[] x1) {
            x0.dataValue = x1;
            return x1;
        }
    }
}

