/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.kerberos.messages;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.asn1.util.BitString;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.kerberos.KerberosMessageType;
import org.apache.directory.shared.kerberos.codec.options.ApOptions;
import org.apache.directory.shared.kerberos.components.EncryptedData;
import org.apache.directory.shared.kerberos.messages.KerberosMessage;
import org.apache.directory.shared.kerberos.messages.Ticket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApReq
extends KerberosMessage {
    private static final Logger LOG = LoggerFactory.getLogger(ApReq.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private ApOptions apOptions;
    private Ticket ticket;
    private EncryptedData authenticator;
    private int pvnoLength;
    private int msgTypeLength;
    private int apOptionsLength;
    private int ticketLength;
    private int authenticatorLength;
    private int apReqLength;
    private int apReqSeqLength;

    public ApReq() {
        super(KerberosMessageType.AP_REQ);
    }

    public ApOptions getApOptions() {
        return this.apOptions;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public boolean getOption(int option) {
        return this.apOptions.get(option);
    }

    public void setOption(ApOptions apOptions) {
        this.apOptions = apOptions;
    }

    public void clearOption(int option) {
        this.apOptions.clear(option);
    }

    public EncryptedData getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(EncryptedData authenticator) {
        this.authenticator = authenticator;
    }

    public void setApOptions(ApOptions options2) {
        this.apOptions = options2;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    @Override
    public int computeLength() {
        this.reset();
        this.pvnoLength = 2 + BerValue.getNbBytes((int)this.getProtocolVersionNumber());
        this.msgTypeLength = 2 + BerValue.getNbBytes((int)this.getMessageType().getValue());
        this.apOptionsLength = 2 + this.apOptions.getBytes().length;
        this.ticketLength = this.ticket.computeLength();
        this.authenticatorLength = this.authenticator.computeLength();
        this.apReqLength = 1 + TLV.getNbBytes((int)this.pvnoLength) + this.pvnoLength + 1 + TLV.getNbBytes((int)this.msgTypeLength) + this.msgTypeLength + 1 + TLV.getNbBytes((int)this.apOptionsLength) + this.apOptionsLength + 1 + TLV.getNbBytes((int)this.ticketLength) + this.ticketLength + 1 + TLV.getNbBytes((int)this.authenticatorLength) + this.authenticatorLength;
        this.apReqSeqLength = 1 + TLV.getNbBytes((int)this.apReqLength) + this.apReqLength;
        return 1 + TLV.getNbBytes((int)this.apReqSeqLength) + this.apReqSeqLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            buffer = ByteBuffer.allocate(this.computeLength());
        }
        try {
            buffer.put((byte)110);
            buffer.put(TLV.getBytes((int)this.apReqSeqLength));
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes((int)this.apReqLength));
            buffer.put((byte)-96);
            buffer.put(TLV.getBytes((int)this.pvnoLength));
            BerValue.encode((ByteBuffer)buffer, (int)this.getProtocolVersionNumber());
            buffer.put((byte)-95);
            buffer.put(TLV.getBytes((int)this.msgTypeLength));
            BerValue.encode((ByteBuffer)buffer, (int)this.getMessageType().getValue());
            buffer.put((byte)-94);
            buffer.put(TLV.getBytes((int)this.apOptionsLength));
            BerValue.encode((ByteBuffer)buffer, (BitString)this.apOptions);
            buffer.put((byte)-93);
            buffer.put(TLV.getBytes((int)this.ticketLength));
            this.ticket.encode(buffer);
            buffer.put((byte)-92);
            buffer.put(TLV.getBytes((int)this.authenticatorLength));
            this.authenticator.encode(buffer);
        }
        catch (BufferOverflowException boe) {
            LOG.error(I18n.err(I18n.ERR_137, 1 + TLV.getNbBytes((int)this.apReqLength) + this.apReqLength, buffer.capacity()));
            throw new EncoderException(I18n.err(I18n.ERR_138, new Object[0]));
        }
        if (IS_DEBUG) {
            LOG.debug("AP-REQ encoding : {}", (Object)Strings.dumpBytes(buffer.array()));
            LOG.debug("AP-REQ initial value : {}", (Object)this.toString());
        }
        return buffer;
    }

    private void reset() {
        this.pvnoLength = 0;
        this.msgTypeLength = 0;
        this.apOptionsLength = 0;
        this.ticketLength = 0;
        this.authenticatorLength = 0;
        this.apReqLength = 0;
        this.apReqSeqLength = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AP-REQ :\n");
        sb.append("  pvno : ").append(this.getProtocolVersionNumber()).append("\n");
        sb.append("  msg-type : ").append((Object)this.getMessageType()).append("\n");
        sb.append("  ap-options : ").append(this.apOptions).append("\n");
        sb.append("  ticket : ").append(this.ticket).append("\n");
        sb.append("  authenticator : ").append(this.authenticator).append("\n");
        return sb.toString();
    }
}

