/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.ByteBufferKeyValue;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.NoTagsKeyValue;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class NoTagsByteBufferKeyValue
extends ByteBufferKeyValue {
    public NoTagsByteBufferKeyValue(ByteBuffer buf, int offset2, int length2) {
        super(buf, offset2, length2);
    }

    public NoTagsByteBufferKeyValue(ByteBuffer buf, int offset2, int length2, long seqId) {
        super(buf, offset2, length2, seqId);
    }

    @Override
    public byte[] getTagsArray() {
        return HConstants.EMPTY_BYTE_ARRAY;
    }

    @Override
    public int getTagsLength() {
        return 0;
    }

    @Override
    public int getSerializedSize(boolean withTags) {
        return this.length;
    }

    @Override
    public ExtendedCell deepClone() {
        byte[] copy = new byte[this.length];
        ByteBufferUtils.copyFromBufferToArray(copy, this.buf, this.offset, 0, this.length);
        NoTagsKeyValue kv = new NoTagsKeyValue(copy, 0, copy.length);
        kv.setSequenceId(this.getSequenceId());
        return kv;
    }
}

