/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hbase.thirdparty.io.netty.util.Timer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AsyncClientScanner {
    private final Scan scan;
    private final ScanMetrics scanMetrics;
    private final AdvancedScanResultConsumer consumer;
    private final TableName tableName;
    private final AsyncConnectionImpl conn;
    private final Timer retryTimer;
    private final long pauseNs;
    private final long pauseForCQTBENs;
    private final int maxAttempts;
    private final long scanTimeoutNs;
    private final long rpcTimeoutNs;
    private final int startLogErrorsCnt;
    private final ScanResultCache resultCache;
    private final AtomicInteger openScannerTries = new AtomicInteger();

    public AsyncClientScanner(Scan scan2, AdvancedScanResultConsumer consumer, TableName tableName, AsyncConnectionImpl conn, Timer retryTimer, long pauseNs, long pauseForCQTBENs, int maxAttempts, long scanTimeoutNs, long rpcTimeoutNs, int startLogErrorsCnt) {
        if (scan2.getStartRow() == null) {
            scan2.withStartRow(HConstants.EMPTY_START_ROW, scan2.includeStartRow());
        }
        if (scan2.getStopRow() == null) {
            scan2.withStopRow(HConstants.EMPTY_END_ROW, scan2.includeStopRow());
        }
        this.scan = scan2;
        this.consumer = consumer;
        this.tableName = tableName;
        this.conn = conn;
        this.retryTimer = retryTimer;
        this.pauseNs = pauseNs;
        this.pauseForCQTBENs = pauseForCQTBENs;
        this.maxAttempts = maxAttempts;
        this.scanTimeoutNs = scanTimeoutNs;
        this.rpcTimeoutNs = rpcTimeoutNs;
        this.startLogErrorsCnt = startLogErrorsCnt;
        this.resultCache = ConnectionUtils.createScanResultCache(scan2);
        if (scan2.isScanMetricsEnabled()) {
            this.scanMetrics = new ScanMetrics();
            consumer.onScanMetricsCreated(this.scanMetrics);
        } else {
            this.scanMetrics = null;
        }
    }

    private CompletableFuture<OpenScannerResponse> callOpenScanner(HBaseRpcController controller, HRegionLocation loc, ClientProtos.ClientService.Interface stub) {
        boolean isRegionServerRemote = ConnectionUtils.isRemote(loc.getHostname());
        ConnectionUtils.incRPCCallsMetrics(this.scanMetrics, isRegionServerRemote);
        if (this.openScannerTries.getAndIncrement() > 1) {
            ConnectionUtils.incRPCRetriesMetrics(this.scanMetrics, isRegionServerRemote);
        }
        CompletableFuture<OpenScannerResponse> future = new CompletableFuture<OpenScannerResponse>();
        try {
            ClientProtos.ScanRequest request = RequestConverter.buildScanRequest(loc.getRegion().getRegionName(), this.scan, this.scan.getCaching(), false);
            stub.scan(controller, request, resp -> {
                if (controller.failed()) {
                    future.completeExceptionally(controller.getFailed());
                    return;
                }
                future.complete(new OpenScannerResponse(loc, isRegionServerRemote, stub, controller, (ClientProtos.ScanResponse)resp));
            });
        }
        catch (IOException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    private void startScan(OpenScannerResponse resp) {
        FutureUtils.addListener(this.conn.callerFactory.scanSingleRegion().id(resp.resp.getScannerId()).location(resp.loc).remote(resp.isRegionServerRemote).scannerLeaseTimeoutPeriod(resp.resp.getTtl(), TimeUnit.MILLISECONDS).stub(resp.stub).setScan(this.scan).metrics(this.scanMetrics).consumer(this.consumer).resultCache(this.resultCache).rpcTimeout(this.rpcTimeoutNs, TimeUnit.NANOSECONDS).scanTimeout(this.scanTimeoutNs, TimeUnit.NANOSECONDS).pause(this.pauseNs, TimeUnit.NANOSECONDS).pauseForCQTBE(this.pauseForCQTBENs, TimeUnit.NANOSECONDS).maxAttempts(this.maxAttempts).startLogErrorsCnt(this.startLogErrorsCnt).start(resp.controller, resp.resp), (hasMore, error2) -> {
            if (error2 != null) {
                this.consumer.onError((Throwable)error2);
                return;
            }
            if (hasMore.booleanValue()) {
                this.openScanner();
            } else {
                this.consumer.onComplete();
            }
        });
    }

    private CompletableFuture<OpenScannerResponse> openScanner(int replicaId) {
        return this.conn.callerFactory.single().table(this.tableName).row(this.scan.getStartRow()).replicaId(replicaId).locateType(ConnectionUtils.getLocateType(this.scan)).rpcTimeout(this.rpcTimeoutNs, TimeUnit.NANOSECONDS).operationTimeout(this.scanTimeoutNs, TimeUnit.NANOSECONDS).pause(this.pauseNs, TimeUnit.NANOSECONDS).pauseForCQTBE(this.pauseForCQTBENs, TimeUnit.NANOSECONDS).maxAttempts(this.maxAttempts).startLogErrorsCnt(this.startLogErrorsCnt).action(this::callOpenScanner).call();
    }

    private long getPrimaryTimeoutNs() {
        return TableName.isMetaTableName(this.tableName) ? this.conn.connConf.getPrimaryMetaScanTimeoutNs() : this.conn.connConf.getPrimaryScanTimeoutNs();
    }

    private void openScanner() {
        ConnectionUtils.incRegionCountMetrics(this.scanMetrics);
        this.openScannerTries.set(1);
        FutureUtils.addListener(ConnectionUtils.timelineConsistentRead(this.conn.getLocator(), this.tableName, this.scan, this.scan.getStartRow(), ConnectionUtils.getLocateType(this.scan), this::openScanner, this.rpcTimeoutNs, this.getPrimaryTimeoutNs(), this.retryTimer, this.conn.getConnectionMetrics()), (resp, error2) -> {
            if (error2 != null) {
                this.consumer.onError((Throwable)error2);
                return;
            }
            this.startScan((OpenScannerResponse)resp);
        });
    }

    public void start() {
        this.openScanner();
    }

    private static final class OpenScannerResponse {
        public final HRegionLocation loc;
        public final boolean isRegionServerRemote;
        public final ClientProtos.ClientService.Interface stub;
        public final HBaseRpcController controller;
        public final ClientProtos.ScanResponse resp;

        public OpenScannerResponse(HRegionLocation loc, boolean isRegionServerRemote, ClientProtos.ClientService.Interface stub, HBaseRpcController controller, ClientProtos.ScanResponse resp) {
            this.loc = loc;
            this.isRegionServerRemote = isRegionServerRemote;
            this.stub = stub;
            this.controller = controller;
            this.resp = resp;
        }
    }
}

