/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnectionConfiguration;
import org.apache.hadoop.hbase.client.AsyncTableBuilder;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.ScanResultConsumerBase;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class AsyncTableBuilderBase<C extends ScanResultConsumerBase>
implements AsyncTableBuilder<C> {
    protected TableName tableName;
    protected long operationTimeoutNs;
    protected long scanTimeoutNs;
    protected long rpcTimeoutNs;
    protected long readRpcTimeoutNs;
    protected long writeRpcTimeoutNs;
    protected long pauseNs;
    protected long pauseForCQTBENs;
    protected int maxAttempts;
    protected int startLogErrorsCnt;

    AsyncTableBuilderBase(TableName tableName, AsyncConnectionConfiguration connConf) {
        this.tableName = tableName;
        this.operationTimeoutNs = tableName.isSystemTable() ? connConf.getMetaOperationTimeoutNs() : connConf.getOperationTimeoutNs();
        this.scanTimeoutNs = connConf.getScanTimeoutNs();
        this.rpcTimeoutNs = connConf.getRpcTimeoutNs();
        this.readRpcTimeoutNs = connConf.getReadRpcTimeoutNs();
        this.writeRpcTimeoutNs = connConf.getWriteRpcTimeoutNs();
        this.pauseNs = connConf.getPauseNs();
        this.pauseForCQTBENs = connConf.getPauseForCQTBENs();
        this.maxAttempts = ConnectionUtils.retries2Attempts(connConf.getMaxRetries());
        this.startLogErrorsCnt = connConf.getStartLogErrorsCnt();
    }

    @Override
    public AsyncTableBuilderBase<C> setOperationTimeout(long timeout2, TimeUnit unit) {
        this.operationTimeoutNs = unit.toNanos(timeout2);
        return this;
    }

    @Override
    public AsyncTableBuilderBase<C> setScanTimeout(long timeout2, TimeUnit unit) {
        this.scanTimeoutNs = unit.toNanos(timeout2);
        return this;
    }

    @Override
    public AsyncTableBuilderBase<C> setRpcTimeout(long timeout2, TimeUnit unit) {
        this.rpcTimeoutNs = unit.toNanos(timeout2);
        return this;
    }

    @Override
    public AsyncTableBuilderBase<C> setReadRpcTimeout(long timeout2, TimeUnit unit) {
        this.readRpcTimeoutNs = unit.toNanos(timeout2);
        return this;
    }

    @Override
    public AsyncTableBuilderBase<C> setWriteRpcTimeout(long timeout2, TimeUnit unit) {
        this.writeRpcTimeoutNs = unit.toNanos(timeout2);
        return this;
    }

    @Override
    public AsyncTableBuilderBase<C> setRetryPause(long pause, TimeUnit unit) {
        this.pauseNs = unit.toNanos(pause);
        return this;
    }

    @Override
    public AsyncTableBuilderBase<C> setRetryPauseForCQTBE(long pause, TimeUnit unit) {
        this.pauseForCQTBENs = unit.toNanos(pause);
        return this;
    }

    @Override
    public AsyncTableBuilderBase<C> setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
        return this;
    }

    @Override
    public AsyncTableBuilderBase<C> setStartLogErrorsCnt(int startLogErrorsCnt) {
        this.startLogErrorsCnt = startLogErrorsCnt;
        return this;
    }
}

