/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcChannel;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hbase.client.AsyncRpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.ClientCoprocessorRpcController;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RegionServerCoprocessorRpcChannelImpl
implements RpcChannel {
    AsyncRpcRetryingCallerFactory.ServerRequestCallerBuilder<Message> callerBuilder;

    RegionServerCoprocessorRpcChannelImpl(AsyncRpcRetryingCallerFactory.ServerRequestCallerBuilder<Message> callerBuilder) {
        this.callerBuilder = callerBuilder;
    }

    private CompletableFuture<Message> rpcCall(Descriptors.MethodDescriptor method2, Message request, final Message responsePrototype, final HBaseRpcController controller, ClientProtos.ClientService.Interface stub) {
        final CompletableFuture<Message> future = new CompletableFuture<Message>();
        ClientProtos.CoprocessorServiceRequest csr = CoprocessorRpcUtils.getCoprocessorServiceRequest(method2, request);
        stub.execRegionServerService(controller, csr, new org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback<ClientProtos.CoprocessorServiceResponse>(){

            @Override
            public void run(ClientProtos.CoprocessorServiceResponse resp) {
                if (controller.failed()) {
                    future.completeExceptionally(controller.getFailed());
                } else {
                    try {
                        future.complete(CoprocessorRpcUtils.getResponse(resp, responsePrototype));
                    }
                    catch (IOException e) {
                        future.completeExceptionally(e);
                    }
                }
            }
        });
        return future;
    }

    @Override
    public void callMethod(Descriptors.MethodDescriptor method2, RpcController controller, Message request, Message responsePrototype, RpcCallback<Message> done) {
        FutureUtils.addListener(this.callerBuilder.action((c, s2) -> this.rpcCall(method2, request, responsePrototype, c, s2)).call(), (r, e) -> {
            if (e != null) {
                ((ClientCoprocessorRpcController)controller).setFailed((Throwable)e);
            }
            done.run((Message)r);
        });
    }
}

