/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ComparatorProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class BitComparator
extends ByteArrayComparable {
    protected BitwiseOp bitOperator;

    public BitComparator(byte[] value2, BitwiseOp bitOperator) {
        super(value2);
        this.bitOperator = bitOperator;
    }

    public BitwiseOp getOperator() {
        return this.bitOperator;
    }

    @Override
    public byte[] toByteArray() {
        ComparatorProtos.BitComparator.Builder builder = ComparatorProtos.BitComparator.newBuilder();
        builder.setComparable(ProtobufUtil.toByteArrayComparable(this.value));
        ComparatorProtos.BitComparator.BitwiseOp bitwiseOpPb = ComparatorProtos.BitComparator.BitwiseOp.valueOf(this.bitOperator.name());
        builder.setBitwiseOp(bitwiseOpPb);
        return builder.build().toByteArray();
    }

    public static BitComparator parseFrom(byte[] pbBytes) throws DeserializationException {
        ComparatorProtos.BitComparator proto;
        try {
            proto = ComparatorProtos.BitComparator.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        BitwiseOp bitwiseOp = BitwiseOp.valueOf(proto.getBitwiseOp().name());
        return new BitComparator(proto.getComparable().getValue().toByteArray(), bitwiseOp);
    }

    @Override
    boolean areSerializedFieldsEqual(ByteArrayComparable other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BitComparator)) {
            return false;
        }
        BitComparator comparator = (BitComparator)other;
        return super.areSerializedFieldsEqual(other) && this.getOperator().equals((Object)comparator.getOperator());
    }

    @Override
    public int compareTo(byte[] value2, int offset2, int length2) {
        if (length2 != this.value.length) {
            return 1;
        }
        int b = 0;
        block5: for (int i2 = length2 - 1; i2 >= 0 && b == 0; --i2) {
            switch (this.bitOperator) {
                case AND: {
                    b = this.value[i2] & value2[i2 + offset2] & 0xFF;
                    continue block5;
                }
                case OR: {
                    b = (this.value[i2] | value2[i2 + offset2]) & 0xFF;
                    continue block5;
                }
                case XOR: {
                    b = (this.value[i2] ^ value2[i2 + offset2]) & 0xFF;
                }
            }
        }
        return b == 0 ? 1 : 0;
    }

    @Override
    public int compareTo(ByteBuffer value2, int offset2, int length2) {
        if (length2 != this.value.length) {
            return 1;
        }
        int b = 0;
        block5: for (int i2 = length2 - 1; i2 >= 0 && b == 0; --i2) {
            switch (this.bitOperator) {
                case AND: {
                    b = this.value[i2] & value2.get(i2 + offset2) & 0xFF;
                    continue block5;
                }
                case OR: {
                    b = (this.value[i2] | value2.get(i2 + offset2)) & 0xFF;
                    continue block5;
                }
                case XOR: {
                    b = (this.value[i2] ^ value2.get(i2 + offset2)) & 0xFF;
                }
            }
        }
        return b == 0 ? 1 : 0;
    }

    @InterfaceAudience.Public
    public static enum BitwiseOp {
        AND,
        OR,
        XOR;

    }
}

