/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class ColumnPaginationFilter
extends FilterBase {
    private int limit = 0;
    private int offset = -1;
    private byte[] columnOffset = null;
    private int count = 0;

    public ColumnPaginationFilter(int limit2, int offset2) {
        Preconditions.checkArgument(limit2 >= 0, "limit must be positive %s", limit2);
        Preconditions.checkArgument(offset2 >= 0, "offset must be positive %s", offset2);
        this.limit = limit2;
        this.offset = offset2;
    }

    public ColumnPaginationFilter(int limit2, byte[] columnOffset) {
        Preconditions.checkArgument(limit2 >= 0, "limit must be positive %s", limit2);
        Preconditions.checkArgument(columnOffset != null, "columnOffset must be non-null %s", (Object)columnOffset);
        this.limit = limit2;
        this.columnOffset = columnOffset;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getColumnOffset() {
        return this.columnOffset;
    }

    @Override
    public boolean filterRowKey(Cell cell) throws IOException {
        return false;
    }

    @Override
    @Deprecated
    public Filter.ReturnCode filterKeyValue(Cell c) {
        return this.filterCell(c);
    }

    @Override
    public Filter.ReturnCode filterCell(Cell c) {
        if (this.columnOffset != null) {
            if (this.count >= this.limit) {
                return Filter.ReturnCode.NEXT_ROW;
            }
            int cmp2 = 0;
            if (this.count == 0) {
                cmp2 = CellUtil.compareQualifiers(c, this.columnOffset, 0, this.columnOffset.length);
            }
            if (cmp2 < 0) {
                return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
            }
            ++this.count;
            return Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
        }
        if (this.count >= this.offset + this.limit) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        Filter.ReturnCode code = this.count < this.offset ? Filter.ReturnCode.NEXT_COL : Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
        ++this.count;
        return code;
    }

    @Override
    public Cell getNextCellHint(Cell cell) {
        return PrivateCellUtil.createFirstOnRowCol(cell, this.columnOffset, 0, this.columnOffset.length);
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument(filterArguments.size() == 2, "Expected 2 but got: %s", filterArguments.size());
        int limit2 = ParseFilter.convertByteArrayToInt(filterArguments.get(0));
        int offset2 = ParseFilter.convertByteArrayToInt(filterArguments.get(1));
        return new ColumnPaginationFilter(limit2, offset2);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.ColumnPaginationFilter.Builder builder = FilterProtos.ColumnPaginationFilter.newBuilder();
        builder.setLimit(this.limit);
        if (this.offset >= 0) {
            builder.setOffset(this.offset);
        }
        if (this.columnOffset != null) {
            builder.setColumnOffset(UnsafeByteOperations.unsafeWrap(this.columnOffset));
        }
        return builder.build().toByteArray();
    }

    public static ColumnPaginationFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.ColumnPaginationFilter proto;
        try {
            proto = FilterProtos.ColumnPaginationFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        if (proto.hasColumnOffset()) {
            return new ColumnPaginationFilter(proto.getLimit(), proto.getColumnOffset().toByteArray());
        }
        return new ColumnPaginationFilter(proto.getLimit(), proto.getOffset());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnPaginationFilter)) {
            return false;
        }
        ColumnPaginationFilter other = (ColumnPaginationFilter)o;
        if (this.columnOffset != null) {
            return this.getLimit() == other.getLimit() && Bytes.equals(this.getColumnOffset(), other.getColumnOffset());
        }
        return this.getLimit() == other.getLimit() && this.getOffset() == other.getOffset();
    }

    @Override
    public String toString() {
        if (this.columnOffset != null) {
            return this.getClass().getSimpleName() + "(" + this.limit + ", " + Bytes.toStringBinary(this.columnOffset) + ")";
        }
        return String.format("%s (%d, %d)", this.getClass().getSimpleName(), this.limit, this.offset);
    }

    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    public int hashCode() {
        return this.columnOffset == null ? Objects.hash(this.limit, this.offset) : Objects.hash(this.limit, Bytes.hashCode(this.columnOffset));
    }
}

