/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.logging;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class Log4jUtils {
    private static final String INTERNAL_UTILS_CLASS_NAME = "org.apache.hadoop.hbase.logging.InternalLog4jUtils";

    private Log4jUtils() {
    }

    private static Method getMethod(String methodName, Class<?> ... args2) {
        try {
            Class<?> clazz = Class.forName(INTERNAL_UTILS_CLASS_NAME);
            return clazz.getDeclaredMethod(methodName, args2);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new AssertionError("should not happen", e);
        }
    }

    private static void throwUnchecked(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    public static void setLogLevel(String loggerName, String levelName) {
        Method method2 = Log4jUtils.getMethod("setLogLevel", String.class, String.class);
        try {
            method2.invoke(null, loggerName, levelName);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("should not happen", e);
        }
        catch (InvocationTargetException e) {
            Log4jUtils.throwUnchecked(e.getCause());
            throw new AssertionError("should not happen", e.getCause());
        }
    }

    public static String getEffectiveLevel(String loggerName) {
        Method method2 = Log4jUtils.getMethod("getEffectiveLevel", String.class);
        try {
            return (String)method2.invoke(null, loggerName);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("should not happen", e);
        }
        catch (InvocationTargetException e) {
            Log4jUtils.throwUnchecked(e.getCause());
            throw new AssertionError("should not happen", e.getCause());
        }
    }

    public static Set<File> getActiveLogFiles() throws IOException {
        Method method2 = Log4jUtils.getMethod("getActiveLogFiles", new Class[0]);
        try {
            return (Set)method2.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("should not happen", e);
        }
        catch (InvocationTargetException e) {
            Throwable cause2 = e.getCause();
            Log4jUtils.throwUnchecked(cause2);
            if (cause2 instanceof IOException) {
                throw (IOException)cause2;
            }
            throw new AssertionError("should not happen", cause2);
        }
    }

    public static void disableZkAndClientLoggers() {
        Log4jUtils.setLogLevel("org.apache.zookeeper", "OFF");
        Log4jUtils.setLogLevel("org.apache.hadoop.hbase.zookeeper", "OFF");
        Log4jUtils.setLogLevel("org.apache.hadoop.hbase.client", "OFF");
    }

    public static void enableDebug(Class<?> clazz) {
        Log4jUtils.setLogLevel(clazz.getName(), "DEBUG");
    }
}

