/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class CopyOnWriteArrayMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
ConcurrentNavigableMap<K, V> {
    private final Comparator<? super K> keyComparator;
    private volatile ArrayHolder<K, V> holder;

    public CopyOnWriteArrayMap() {
        this(new Comparator<K>(){

            @Override
            public int compare(K o1, K o2) {
                return ((Comparable)o1).compareTo(o2);
            }
        });
    }

    public CopyOnWriteArrayMap(final Comparator<? super K> keyComparator) {
        this.keyComparator = keyComparator;
        this.holder = new ArrayHolder(keyComparator, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return keyComparator.compare(o1.getKey(), o2.getKey());
            }
        });
    }

    private CopyOnWriteArrayMap(Comparator<? super K> keyComparator, ArrayHolder<K, V> holder) {
        this.keyComparator = keyComparator;
        this.holder = holder;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.keyComparator;
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        ArrayHolder<K, V> current2 = this.holder;
        int index2 = current2.find(fromKey);
        if (!inclusive && index2 >= 0) {
            ++index2;
        } else if (index2 < 0) {
            index2 = -(index2 + 1);
        }
        return new CopyOnWriteArrayMap(this.keyComparator, new ArrayHolder(((ArrayHolder)current2).entries, index2, ((ArrayHolder)current2).endIndex, ((ArrayHolder)current2).keyComparator, ((ArrayHolder)current2).comparator));
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey) {
        return this.tailMap((Object)fromKey, true);
    }

    @Override
    public K firstKey() {
        ArrayHolder<K, V> current2 = this.holder;
        if (current2.getLength() == 0) {
            return null;
        }
        return ((ArrayHolder)current2).entries[((ArrayHolder)current2).startIndex].getKey();
    }

    @Override
    public K lastKey() {
        ArrayHolder<K, V> current2 = this.holder;
        if (current2.getLength() == 0) {
            return null;
        }
        return ((ArrayHolder)current2).entries[((ArrayHolder)current2).endIndex - 1].getKey();
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key2) {
        ArrayHolder<K, V> current2 = this.holder;
        if (current2.getLength() == 0) {
            return null;
        }
        int index2 = current2.find(key2);
        index2 = index2 >= 0 ? --index2 : -(index2 + 1) - 1;
        if (index2 < ((ArrayHolder)current2).startIndex || index2 >= ((ArrayHolder)current2).endIndex) {
            return null;
        }
        return ((ArrayHolder)current2).entries[index2];
    }

    @Override
    public K lowerKey(K key2) {
        Map.Entry<K, V> entry = this.lowerEntry(key2);
        if (entry == null) {
            return null;
        }
        return entry.getKey();
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key2) {
        ArrayHolder<K, V> current2 = this.holder;
        if (current2.getLength() == 0) {
            return null;
        }
        int index2 = current2.find(key2);
        if (index2 < 0) {
            index2 = -(index2 + 1) - 1;
        }
        if (index2 < ((ArrayHolder)current2).startIndex || index2 >= ((ArrayHolder)current2).endIndex) {
            return null;
        }
        return ((ArrayHolder)current2).entries[index2];
    }

    @Override
    public K floorKey(K key2) {
        Map.Entry<K, V> entry = this.floorEntry(key2);
        if (entry == null) {
            return null;
        }
        return entry.getKey();
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key2) {
        ArrayHolder<K, V> current2 = this.holder;
        if (current2.getLength() == 0) {
            return null;
        }
        int index2 = current2.find(key2);
        if (index2 < 0) {
            index2 = -(index2 + 1);
        }
        if (index2 < ((ArrayHolder)current2).startIndex || index2 >= ((ArrayHolder)current2).endIndex) {
            return null;
        }
        return ((ArrayHolder)current2).entries[index2];
    }

    @Override
    public K ceilingKey(K key2) {
        Map.Entry<K, V> entry = this.ceilingEntry(key2);
        if (entry == null) {
            return null;
        }
        return entry.getKey();
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key2) {
        ArrayHolder<K, V> current2 = this.holder;
        if (current2.getLength() == 0) {
            return null;
        }
        int index2 = current2.find(key2);
        index2 = index2 >= 0 ? ++index2 : -(index2 + 1);
        if (index2 < ((ArrayHolder)current2).startIndex || index2 >= ((ArrayHolder)current2).endIndex) {
            return null;
        }
        return ((ArrayHolder)current2).entries[index2];
    }

    @Override
    public K higherKey(K key2) {
        Map.Entry<K, V> entry = this.higherEntry(key2);
        if (entry == null) {
            return null;
        }
        return entry.getKey();
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        ArrayHolder<K, V> current2 = this.holder;
        if (current2.getLength() == 0) {
            return null;
        }
        return ((ArrayHolder)current2).entries[((ArrayHolder)current2).startIndex];
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        ArrayHolder<K, V> current2 = this.holder;
        if (current2.getLength() == 0) {
            return null;
        }
        return ((ArrayHolder)current2).entries[((ArrayHolder)current2).endIndex - 1];
    }

    @Override
    public int size() {
        return this.holder.getLength();
    }

    @Override
    public boolean isEmpty() {
        return this.holder.getLength() == 0;
    }

    @Override
    public boolean containsKey(Object key2) {
        ArrayHolder<Object, V> current2 = this.holder;
        int index2 = current2.find(key2);
        return index2 >= 0;
    }

    @Override
    public V get(Object key2) {
        ArrayHolder<Object, V> current2 = this.holder;
        int index2 = current2.find(key2);
        if (index2 >= 0) {
            return ((ArrayHolder)current2).entries[index2].getValue();
        }
        return null;
    }

    @Override
    public NavigableSet<K> keySet() {
        return new ArrayKeySet(this.holder);
    }

    @Override
    public Collection<V> values() {
        return new ArrayValueCollection(this.holder);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new ArrayEntrySet(this.holder);
    }

    @Override
    public synchronized V put(K key2, V value2) {
        ArrayHolder<K, V> current2 = this.holder;
        int index2 = current2.find(key2);
        COWEntry<K, V> newEntry = new COWEntry<K, V>(key2, value2);
        if (index2 >= 0) {
            this.holder = current2.replace(index2, newEntry);
            return ((ArrayHolder)current2).entries[index2].getValue();
        }
        this.holder = current2.insert(-(index2 + 1), newEntry);
        return null;
    }

    @Override
    public synchronized V remove(Object key2) {
        ArrayHolder<Object, V> current2 = this.holder;
        int index2 = current2.find(key2);
        if (index2 >= 0) {
            this.holder = current2.remove(index2);
            return ((ArrayHolder)current2).entries[index2].getValue();
        }
        return null;
    }

    @Override
    public synchronized void clear() {
        this.holder = new ArrayHolder(((ArrayHolder)this.holder).keyComparator, ((ArrayHolder)this.holder).comparator);
    }

    @Override
    public synchronized V putIfAbsent(K key2, V value2) {
        ArrayHolder<K, V> current2 = this.holder;
        int index2 = current2.find(key2);
        if (index2 < 0) {
            COWEntry<K, V> newEntry = new COWEntry<K, V>(key2, value2);
            this.holder = current2.insert(-(index2 + 1), newEntry);
            return value2;
        }
        return ((ArrayHolder)current2).entries[index2].getValue();
    }

    @Override
    public synchronized boolean remove(Object key2, Object value2) {
        ArrayHolder<Object, V> current2 = this.holder;
        int index2 = current2.find(key2);
        if (index2 >= 0 && ((ArrayHolder)current2).entries[index2].getValue().equals(value2)) {
            this.holder = current2.remove(index2);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean replace(K key2, V oldValue, V newValue) {
        ArrayHolder<K, V> current2 = this.holder;
        int index2 = current2.find(key2);
        if (index2 >= 0 && ((ArrayHolder)current2).entries[index2].getValue().equals(oldValue)) {
            COWEntry<K, V> newEntry = new COWEntry<K, V>(key2, newValue);
            this.holder = current2.replace(index2, newEntry);
            return true;
        }
        return false;
    }

    @Override
    public synchronized V replace(K key2, V value2) {
        ArrayHolder<K, V> current2 = this.holder;
        int index2 = current2.find(key2);
        if (index2 >= 0) {
            COWEntry<K, V> newEntry = new COWEntry<K, V>(key2, value2);
            this.holder = current2.replace(index2, newEntry);
            return ((ArrayHolder)current2).entries[index2].getValue();
        }
        return null;
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConcurrentNavigableMap<K, V> descendingMap() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, K toKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        throw new UnsupportedOperationException();
    }

    private static final class COWEntry<K, V>
    implements Map.Entry<K, V> {
        K key = null;
        V value = null;

        COWEntry(K key2, V value2) {
            this.key = key2;
            this.value = value2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value2) {
            V oldValue = this.value;
            this.value = value2;
            return oldValue;
        }
    }

    private static final class ArrayHolder<K, V> {
        private final COWEntry<K, V>[] entries;
        private final int startIndex;
        private final int endIndex;
        private final Comparator<? super K> keyComparator;
        private final Comparator<Map.Entry<K, V>> comparator;

        int getLength() {
            return this.endIndex - this.startIndex;
        }

        int find(K needle) {
            int begin2 = this.startIndex;
            int end2 = this.endIndex - 1;
            while (begin2 <= end2) {
                int mid = begin2 + (end2 - begin2) / 2;
                Object midKey = this.entries[mid].key;
                int compareRes = this.keyComparator.compare(midKey, needle);
                if (compareRes == 0) {
                    return mid;
                }
                if (compareRes < 0) {
                    begin2 = mid + 1;
                    continue;
                }
                end2 = mid - 1;
            }
            return -1 * begin2 - 1;
        }

        ArrayHolder<K, V> replace(int index2, COWEntry<K, V> newEntry) {
            COWEntry[] newEntries = (COWEntry[])this.entries.clone();
            newEntries[index2] = newEntry;
            return new ArrayHolder<K, V>(newEntries, this.startIndex, this.endIndex, this.keyComparator, this.comparator);
        }

        ArrayHolder<K, V> remove(int index2) {
            COWEntry[] newEntries = new COWEntry[this.getLength() - 1];
            System.arraycopy(this.entries, this.startIndex, newEntries, 0, index2 - this.startIndex);
            System.arraycopy(this.entries, index2 + 1, newEntries, index2, this.entries.length - index2 - 1);
            return new ArrayHolder<K, V>(newEntries, 0, newEntries.length, this.keyComparator, this.comparator);
        }

        ArrayHolder<K, V> insert(int index2, COWEntry<K, V> newEntry) {
            COWEntry[] newEntries = new COWEntry[this.getLength() + 1];
            System.arraycopy(this.entries, this.startIndex, newEntries, 0, index2 - this.startIndex);
            newEntries[index2] = newEntry;
            System.arraycopy(this.entries, index2, newEntries, index2 + 1, this.getLength() - index2);
            return new ArrayHolder<K, V>(newEntries, 0, newEntries.length, this.keyComparator, this.comparator);
        }

        private ArrayHolder(Comparator<? super K> keyComparator, Comparator<Map.Entry<K, V>> comparator) {
            this.endIndex = 0;
            this.startIndex = 0;
            this.entries = new COWEntry[0];
            this.keyComparator = keyComparator;
            this.comparator = comparator;
        }

        private ArrayHolder(COWEntry[] entries2, int startIndex, int endIndex, Comparator<? super K> keyComparator, Comparator<Map.Entry<K, V>> comparator) {
            this.entries = entries2;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.keyComparator = keyComparator;
            this.comparator = comparator;
        }
    }

    private final class ArrayEntrySet<K, V>
    implements Set<Map.Entry<K, V>> {
        private final ArrayHolder<K, V> holder;

        private ArrayEntrySet(ArrayHolder<K, V> holder) {
            this.holder = holder;
        }

        @Override
        public int size() {
            return this.holder.getLength();
        }

        @Override
        public boolean isEmpty() {
            return this.holder.getLength() == 0;
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new ArrayEntryIterator(this.holder);
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Map.Entry<K, V> kvEntry) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ArrayEntryIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        int index;
        private final ArrayHolder<K, V> holder;

        private ArrayEntryIterator(ArrayHolder<K, V> holder) {
            this.holder = holder;
            this.index = ((ArrayHolder)holder).startIndex;
        }

        @Override
        public boolean hasNext() {
            return this.index < ((ArrayHolder)this.holder).endIndex;
        }

        @Override
        @SuppressWarnings(value={"IT_NO_SUCH_ELEMENT"}, justification="Intentional")
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ((ArrayHolder)this.holder).entries[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static final class ArrayValueIterator<K, V>
    implements Iterator<V> {
        int index;
        private final ArrayHolder<K, V> holder;

        private ArrayValueIterator(ArrayHolder<K, V> holder) {
            this.holder = holder;
            this.index = ((ArrayHolder)holder).startIndex;
        }

        @Override
        public boolean hasNext() {
            return this.index < ((ArrayHolder)this.holder).endIndex;
        }

        @Override
        public V next() {
            return ((ArrayHolder)this.holder).entries[this.index++].getValue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static final class ArrayKeyIterator<K, V>
    implements Iterator<K> {
        int index;
        private final ArrayHolder<K, V> holder;

        private ArrayKeyIterator(ArrayHolder<K, V> holder) {
            this.holder = holder;
            this.index = ((ArrayHolder)holder).startIndex;
        }

        @Override
        public boolean hasNext() {
            return this.index < ((ArrayHolder)this.holder).endIndex;
        }

        @Override
        public K next() {
            return ((ArrayHolder)this.holder).entries[this.index++].getKey();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private final class ArrayValueCollection<K, V>
    implements Collection<V> {
        private final ArrayHolder<K, V> holder;

        private ArrayValueCollection(ArrayHolder<K, V> holder) {
            this.holder = holder;
        }

        @Override
        public int size() {
            return this.holder.getLength();
        }

        @Override
        public boolean isEmpty() {
            return this.holder.getLength() == 0;
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<V> iterator() {
            return new ArrayValueIterator(this.holder);
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends V> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        @SuppressWarnings(value={"EQ_ALWAYS_FALSE"}, justification="Intentional")
        public boolean equals(Object o) {
            return false;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }

    private final class ArrayKeySet<K, V>
    implements NavigableSet<K> {
        private final ArrayHolder<K, V> holder;

        private ArrayKeySet(ArrayHolder<K, V> holder) {
            this.holder = holder;
        }

        @Override
        public int size() {
            return this.holder.getLength();
        }

        @Override
        public boolean isEmpty() {
            return this.holder.getLength() == 0;
        }

        @Override
        public boolean contains(Object o) {
            ArrayHolder<K, V> current2 = this.holder;
            for (int i2 = ((ArrayHolder)current2).startIndex; i2 < ((ArrayHolder)current2).endIndex; ++i2) {
                if (!((ArrayHolder)current2).entries[i2].getValue().equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public K lower(K k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K floor(K k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K ceiling(K k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K higher(K k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public K pollFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K pollLast() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<K> iterator() {
            return new ArrayKeyIterator(this.holder);
        }

        @Override
        public NavigableSet<K> descendingSet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<K> descendingIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableSet<K> subSet(K fromElement, boolean fromInclusive, K toElement, boolean toInclusive) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableSet<K> headSet(K toElement, boolean inclusive) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableSet<K> tailSet(K fromElement, boolean inclusive) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Comparator<? super K> comparator() {
            return CopyOnWriteArrayMap.this.keyComparator;
        }

        @Override
        public SortedSet<K> subSet(K fromElement, K toElement) {
            return null;
        }

        @Override
        public SortedSet<K> headSet(K toElement) {
            return null;
        }

        @Override
        public SortedSet<K> tailSet(K fromElement) {
            return null;
        }

        @Override
        public K first() {
            ArrayHolder<K, V> current2 = this.holder;
            if (current2.getLength() == 0) {
                return null;
            }
            return ((ArrayHolder)current2).entries[((ArrayHolder)current2).startIndex].getKey();
        }

        @Override
        public K last() {
            ArrayHolder<K, V> current2 = this.holder;
            if (current2.getLength() == 0) {
                return null;
            }
            return ((ArrayHolder)current2).entries[((ArrayHolder)current2).endIndex - 1].getKey();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(K k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

