/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.util.AbstractByteRange;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class AbstractPositionedByteRange
extends AbstractByteRange
implements PositionedByteRange {
    protected int position = 0;
    protected int limit = 0;

    @Override
    public PositionedByteRange set(int capacity) {
        this.position = 0;
        super.set(capacity);
        this.limit = capacity;
        return this;
    }

    @Override
    public PositionedByteRange set(byte[] bytes2) {
        this.position = 0;
        super.set(bytes2);
        this.limit = bytes2.length;
        return this;
    }

    @Override
    public PositionedByteRange set(byte[] bytes2, int offset2, int length2) {
        this.position = 0;
        super.set(bytes2, offset2, length2);
        this.limit = length2;
        return this;
    }

    @Override
    public PositionedByteRange setOffset(int offset2) {
        this.position = 0;
        super.setOffset(offset2);
        return this;
    }

    @Override
    public PositionedByteRange setLength(int length2) {
        this.position = Math.min(this.position, length2);
        super.setLength(length2);
        return this;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public PositionedByteRange setPosition(int position) {
        this.position = position;
        return this;
    }

    @Override
    public int getRemaining() {
        return this.length - this.position;
    }

    @Override
    public byte peek() {
        return this.bytes[this.offset + this.position];
    }

    @Override
    public byte get() {
        return this.get(this.position++);
    }

    @Override
    public PositionedByteRange get(byte[] dst) {
        if (0 == dst.length) {
            return this;
        }
        return this.get(dst, 0, dst.length);
    }

    @Override
    public PositionedByteRange get(byte[] dst, int offset2, int length2) {
        if (0 == length2) {
            return this;
        }
        super.get(this.position, dst, offset2, length2);
        this.position += length2;
        return this;
    }

    @Override
    public PositionedByteRange get(int index2, byte[] dst) {
        super.get(index2, dst);
        return this;
    }

    @Override
    public PositionedByteRange get(int index2, byte[] dst, int offset2, int length2) {
        super.get(index2, dst, offset2, length2);
        return this;
    }

    @Override
    public short getShort() {
        short s2 = this.getShort(this.position);
        this.position += 2;
        return s2;
    }

    @Override
    public int getInt() {
        int i2 = this.getInt(this.position);
        this.position += 4;
        return i2;
    }

    @Override
    public long getLong() {
        long l = this.getLong(this.position);
        this.position += 8;
        return l;
    }

    @Override
    public long getVLong() {
        long p2 = this.getVLong(this.position);
        this.position += AbstractPositionedByteRange.getVLongSize(p2);
        return p2;
    }

    @Override
    public PositionedByteRange setLimit(int limit2) {
        this.limit = limit2;
        return this;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }
}

