/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class PoolMap<K, V> {
    private final Map<K, Pool<V>> pools = new HashMap<K, Pool<V>>();
    private final PoolType poolType;
    private final int poolMaxSize;

    public PoolMap(PoolType poolType, int poolMaxSize) {
        this.poolType = poolType;
        this.poolMaxSize = poolMaxSize;
    }

    public V getOrCreate(K key2, PoolResourceSupplier<V> supplier) throws IOException {
        Map<K, Pool<V>> map = this.pools;
        synchronized (map) {
            Pool<V> pool = this.pools.get(key2);
            if (pool == null) {
                pool = this.createPool();
                this.pools.put(key2, pool);
            }
            try {
                return pool.getOrCreate(supplier);
            }
            catch (IOException | Error | RuntimeException e) {
                if (pool.size() == 0) {
                    this.pools.remove(key2);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key2, V value2) {
        Map<K, Pool<V>> map = this.pools;
        synchronized (map) {
            Pool<V> pool = this.pools.get(key2);
            if (pool == null) {
                return false;
            }
            boolean removed = pool.remove(value2);
            if (removed && pool.size() == 0) {
                this.pools.remove(key2);
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<V> values() {
        ArrayList<V> values = new ArrayList<V>();
        Map<K, Pool<V>> map = this.pools;
        synchronized (map) {
            for (Pool<V> pool : this.pools.values()) {
                Collection<V> poolValues = pool.values();
                if (poolValues == null) continue;
                values.addAll(poolValues);
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<K, Pool<V>> map = this.pools;
        synchronized (map) {
            for (Pool<V> pool : this.pools.values()) {
                pool.clear();
            }
            this.pools.clear();
        }
    }

    protected static <V> V createResource(PoolResourceSupplier<V> supplier) throws IOException {
        V resource2 = supplier.get();
        return Objects.requireNonNull(resource2, "resource cannot be null.");
    }

    protected Pool<V> createPool() {
        switch (this.poolType) {
            case RoundRobin: {
                return new RoundRobinPool(this.poolMaxSize);
            }
            case ThreadLocal: {
                return new ThreadLocalPool();
            }
        }
        return new RoundRobinPool(this.poolMaxSize);
    }

    static class ThreadLocalPool<R>
    implements Pool<R> {
        private final Map<Thread, R> resources = new HashMap<Thread, R>();

        @Override
        public R getOrCreate(PoolResourceSupplier<R> supplier) throws IOException {
            Thread myself = Thread.currentThread();
            R resource2 = this.resources.get(myself);
            if (resource2 == null) {
                resource2 = PoolMap.createResource(supplier);
                this.resources.put(myself, resource2);
            }
            return resource2;
        }

        @Override
        public boolean remove(R resource2) {
            return this.resources.values().remove(resource2);
        }

        @Override
        public int size() {
            return this.resources.size();
        }

        @Override
        public void clear() {
            this.resources.clear();
        }

        @Override
        public Collection<R> values() {
            return this.resources.values();
        }
    }

    static class RoundRobinPool<R>
    implements Pool<R> {
        private final List<R> resources;
        private final int maxSize;
        private int nextIndex;

        public RoundRobinPool(int maxSize) {
            if (maxSize <= 0) {
                throw new IllegalArgumentException("maxSize must be positive");
            }
            this.resources = new ArrayList<R>(maxSize);
            this.maxSize = maxSize;
        }

        @Override
        public R getOrCreate(PoolResourceSupplier<R> supplier) throws IOException {
            R resource2;
            int size2 = this.resources.size();
            if (size2 < this.maxSize) {
                resource2 = PoolMap.createResource(supplier);
                this.resources.add(resource2);
            } else {
                resource2 = this.resources.get(this.nextIndex);
                this.nextIndex = (this.nextIndex + 1) % size2;
            }
            return resource2;
        }

        @Override
        public boolean remove(R resource2) {
            return this.resources.remove(resource2);
        }

        @Override
        public void clear() {
            this.resources.clear();
        }

        @Override
        public Collection<R> values() {
            return this.resources;
        }

        @Override
        public int size() {
            return this.resources.size();
        }
    }

    public static enum PoolType {
        ThreadLocal,
        RoundRobin;


        public static PoolType valueOf(String poolTypeName, PoolType defaultPoolType) {
            PoolType poolType = PoolType.fuzzyMatch(poolTypeName);
            return poolType != null ? poolType : defaultPoolType;
        }

        public static String fuzzyNormalize(String name2) {
            return name2 != null ? name2.replaceAll("-", "").trim().toLowerCase(Locale.ROOT) : "";
        }

        public static PoolType fuzzyMatch(String name2) {
            for (PoolType poolType : PoolType.values()) {
                if (!PoolType.fuzzyNormalize(name2).equals(PoolType.fuzzyNormalize(poolType.name()))) continue;
                return poolType;
            }
            return null;
        }
    }

    protected static interface Pool<R> {
        public R getOrCreate(PoolResourceSupplier<R> var1) throws IOException;

        public boolean remove(R var1);

        public void clear();

        public Collection<R> values();

        public int size();
    }

    public static interface PoolResourceSupplier<R> {
        public R get() throws IOException;
    }
}

