/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.hbase.util.MovingAverage;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class WindowMovingAverage
extends MovingAverage {
    protected static final int DEFAULT_SIZE = 5;
    protected long[] lastN;
    protected int mostRecent;
    protected boolean oneRound;

    public WindowMovingAverage(String label) {
        this(label, 5);
    }

    public WindowMovingAverage(String label, int size2) {
        super(label);
        this.lastN = new long[size2 <= 0 ? 5 : size2];
        this.mostRecent = -1;
        this.oneRound = false;
    }

    @Override
    protected void updateMostRecentTime(long elapsed) {
        int index2 = this.moveForwardMostRecentPosistion();
        this.lastN[index2] = elapsed;
    }

    @Override
    public double getAverageTime() {
        return this.enoughStatistics() ? (double)this.sum(this.getNumberOfStatistics()) / (double)this.getNumberOfStatistics() : (double)this.sum(this.getMostRecentPosistion() + 1) / (double)(this.getMostRecentPosistion() + 1);
    }

    protected boolean enoughStatistics() {
        return this.oneRound;
    }

    protected int getNumberOfStatistics() {
        return this.lastN.length;
    }

    protected long getStatisticsAtIndex(int index2) {
        if (index2 < 0 || index2 >= this.getNumberOfStatistics()) {
            throw new IndexOutOfBoundsException();
        }
        return this.lastN[index2];
    }

    protected int getMostRecentPosistion() {
        return this.mostRecent;
    }

    protected int moveForwardMostRecentPosistion() {
        int index2 = ++this.mostRecent;
        if (!this.oneRound && index2 == this.getNumberOfStatistics()) {
            this.oneRound = true;
        }
        this.mostRecent = index2 % this.getNumberOfStatistics();
        return this.mostRecent;
    }

    private long sum(int bound) {
        long sum2 = 0L;
        for (int i2 = 0; i2 < bound; ++i2) {
            sum2 += this.getStatisticsAtIndex(i2);
        }
        return sum2;
    }
}

