/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.common.collect;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.hbase.thirdparty.com.google.common.annotations.GwtCompatible;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableCollection;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMapEntrySet;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMapKeySet;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMapValues;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.collect.RegularImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
final class JdkBackedImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private final transient Map<K, V> delegateMap;
    private final transient ImmutableList<Map.Entry<K, V>> entries;

    static <K, V> ImmutableMap<K, V> create(int n, Map.Entry<K, V>[] entryArray) {
        HashMap<K, V> delegateMap = Maps.newHashMapWithExpectedSize(n);
        for (int i2 = 0; i2 < n; ++i2) {
            entryArray[i2] = RegularImmutableMap.makeImmutable(entryArray[i2]);
            V oldValue = delegateMap.putIfAbsent(entryArray[i2].getKey(), entryArray[i2].getValue());
            if (oldValue == null) continue;
            String string2 = String.valueOf(entryArray[i2].getKey());
            String string3 = String.valueOf(oldValue);
            throw JdkBackedImmutableMap.conflictException("key", entryArray[i2], new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("=").append(string3).toString());
        }
        return new JdkBackedImmutableMap(delegateMap, ImmutableList.asImmutableList(entryArray, n));
    }

    JdkBackedImmutableMap(Map<K, V> delegateMap, ImmutableList<Map.Entry<K, V>> entries2) {
        this.delegateMap = delegateMap;
        this.entries = entries2;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public V get(@Nullable Object key2) {
        return this.delegateMap.get(key2);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        this.entries.forEach((Consumer<Map.Entry<K, V>>)((Consumer<Map.Entry>)e -> action.accept((Object)e.getKey(), (Object)e.getValue())));
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new ImmutableMapValues(this);
    }

    @Override
    boolean isPartialView() {
        return false;
    }
}

