/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.common.hash;

import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.hash.AbstractNonStreamingHashFunction;
import org.apache.hbase.thirdparty.com.google.common.hash.HashCode;
import org.apache.hbase.thirdparty.com.google.common.hash.HashFunction;
import org.apache.hbase.thirdparty.com.google.common.hash.LittleEndianByteArray;

final class FarmHashFingerprint64
extends AbstractNonStreamingHashFunction {
    static final HashFunction FARMHASH_FINGERPRINT_64 = new FarmHashFingerprint64();
    private static final long K0 = -4348849565147123417L;
    private static final long K1 = -5435081209227447693L;
    private static final long K2 = -7286425919675154353L;

    FarmHashFingerprint64() {
    }

    @Override
    public HashCode hashBytes(byte[] input, int off, int len) {
        Preconditions.checkPositionIndexes(off, off + len, input.length);
        return HashCode.fromLong(FarmHashFingerprint64.fingerprint(input, off, len));
    }

    @Override
    public int bits() {
        return 64;
    }

    public String toString() {
        return "Hashing.farmHashFingerprint64()";
    }

    @VisibleForTesting
    static long fingerprint(byte[] bytes2, int offset2, int length2) {
        if (length2 <= 32) {
            if (length2 <= 16) {
                return FarmHashFingerprint64.hashLength0to16(bytes2, offset2, length2);
            }
            return FarmHashFingerprint64.hashLength17to32(bytes2, offset2, length2);
        }
        if (length2 <= 64) {
            return FarmHashFingerprint64.hashLength33To64(bytes2, offset2, length2);
        }
        return FarmHashFingerprint64.hashLength65Plus(bytes2, offset2, length2);
    }

    private static long shiftMix(long val) {
        return val ^ val >>> 47;
    }

    private static long hashLength16(long u, long v, long mul) {
        long a = (u ^ v) * mul;
        a ^= a >>> 47;
        long b = (v ^ a) * mul;
        b ^= b >>> 47;
        return b *= mul;
    }

    private static void weakHashLength32WithSeeds(byte[] bytes2, int offset2, long seedA, long seedB, long[] output) {
        long part1 = LittleEndianByteArray.load64(bytes2, offset2);
        long part2 = LittleEndianByteArray.load64(bytes2, offset2 + 8);
        long part3 = LittleEndianByteArray.load64(bytes2, offset2 + 16);
        long part4 = LittleEndianByteArray.load64(bytes2, offset2 + 24);
        seedB = Long.rotateRight(seedB + (seedA += part1) + part4, 21);
        long c = seedA;
        seedA += part2;
        output[0] = seedA + part4;
        output[1] = (seedB += Long.rotateRight(seedA += part3, 44)) + c;
    }

    private static long hashLength0to16(byte[] bytes2, int offset2, int length2) {
        if (length2 >= 8) {
            long mul = -7286425919675154353L + (long)(length2 * 2);
            long a = LittleEndianByteArray.load64(bytes2, offset2) + -7286425919675154353L;
            long b = LittleEndianByteArray.load64(bytes2, offset2 + length2 - 8);
            long c = Long.rotateRight(b, 37) * mul + a;
            long d = (Long.rotateRight(a, 25) + b) * mul;
            return FarmHashFingerprint64.hashLength16(c, d, mul);
        }
        if (length2 >= 4) {
            long mul = -7286425919675154353L + (long)(length2 * 2);
            long a = (long)LittleEndianByteArray.load32(bytes2, offset2) & 0xFFFFFFFFL;
            return FarmHashFingerprint64.hashLength16((long)length2 + (a << 3), (long)LittleEndianByteArray.load32(bytes2, offset2 + length2 - 4) & 0xFFFFFFFFL, mul);
        }
        if (length2 > 0) {
            byte a = bytes2[offset2];
            byte b = bytes2[offset2 + (length2 >> 1)];
            byte c = bytes2[offset2 + (length2 - 1)];
            int y = (a & 0xFF) + ((b & 0xFF) << 8);
            int z = length2 + ((c & 0xFF) << 2);
            return FarmHashFingerprint64.shiftMix((long)y * -7286425919675154353L ^ (long)z * -4348849565147123417L) * -7286425919675154353L;
        }
        return -7286425919675154353L;
    }

    private static long hashLength17to32(byte[] bytes2, int offset2, int length2) {
        long mul = -7286425919675154353L + (long)(length2 * 2);
        long a = LittleEndianByteArray.load64(bytes2, offset2) * -5435081209227447693L;
        long b = LittleEndianByteArray.load64(bytes2, offset2 + 8);
        long c = LittleEndianByteArray.load64(bytes2, offset2 + length2 - 8) * mul;
        long d = LittleEndianByteArray.load64(bytes2, offset2 + length2 - 16) * -7286425919675154353L;
        return FarmHashFingerprint64.hashLength16(Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
    }

    private static long hashLength33To64(byte[] bytes2, int offset2, int length2) {
        long mul = -7286425919675154353L + (long)(length2 * 2);
        long a = LittleEndianByteArray.load64(bytes2, offset2) * -7286425919675154353L;
        long b = LittleEndianByteArray.load64(bytes2, offset2 + 8);
        long c = LittleEndianByteArray.load64(bytes2, offset2 + length2 - 8) * mul;
        long d = LittleEndianByteArray.load64(bytes2, offset2 + length2 - 16) * -7286425919675154353L;
        long y = Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d;
        long z = FarmHashFingerprint64.hashLength16(y, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
        long e = LittleEndianByteArray.load64(bytes2, offset2 + 16) * mul;
        long f = LittleEndianByteArray.load64(bytes2, offset2 + 24);
        long g = (y + LittleEndianByteArray.load64(bytes2, offset2 + length2 - 32)) * mul;
        long h = (z + LittleEndianByteArray.load64(bytes2, offset2 + length2 - 24)) * mul;
        return FarmHashFingerprint64.hashLength16(Long.rotateRight(e + f, 43) + Long.rotateRight(g, 30) + h, e + Long.rotateRight(f + a, 18) + g, mul);
    }

    private static long hashLength65Plus(byte[] bytes2, int offset2, int length2) {
        int seed2 = 81;
        long x = 81L;
        long y = 2480279821605975764L;
        long z = FarmHashFingerprint64.shiftMix(y * -7286425919675154353L + 113L) * -7286425919675154353L;
        long[] v = new long[2];
        long[] w = new long[2];
        x = x * -7286425919675154353L + LittleEndianByteArray.load64(bytes2, offset2);
        int end2 = offset2 + (length2 - 1) / 64 * 64;
        int last64offset = end2 + (length2 - 1 & 0x3F) - 63;
        do {
            x = Long.rotateRight(x + y + v[0] + LittleEndianByteArray.load64(bytes2, offset2 + 8), 37) * -5435081209227447693L;
            y = Long.rotateRight(y + v[1] + LittleEndianByteArray.load64(bytes2, offset2 + 48), 42) * -5435081209227447693L;
            z = Long.rotateRight(z + w[0], 33) * -5435081209227447693L;
            FarmHashFingerprint64.weakHashLength32WithSeeds(bytes2, offset2, v[1] * -5435081209227447693L, (x ^= w[1]) + w[0], v);
            FarmHashFingerprint64.weakHashLength32WithSeeds(bytes2, offset2 + 32, z + w[1], (y += v[0] + LittleEndianByteArray.load64(bytes2, offset2 + 40)) + LittleEndianByteArray.load64(bytes2, offset2 + 16), w);
            long tmp = x;
            x = z;
            z = tmp;
        } while ((offset2 += 64) != end2);
        long mul = -5435081209227447693L + ((z & 0xFFL) << 1);
        offset2 = last64offset;
        w[0] = w[0] + (long)(length2 - 1 & 0x3F);
        v[0] = v[0] + w[0];
        w[0] = w[0] + v[0];
        x = Long.rotateRight(x + y + v[0] + LittleEndianByteArray.load64(bytes2, offset2 + 8), 37) * mul;
        y = Long.rotateRight(y + v[1] + LittleEndianByteArray.load64(bytes2, offset2 + 48), 42) * mul;
        z = Long.rotateRight(z + w[0], 33) * mul;
        FarmHashFingerprint64.weakHashLength32WithSeeds(bytes2, offset2, v[1] * mul, (x ^= w[1] * 9L) + w[0], v);
        FarmHashFingerprint64.weakHashLength32WithSeeds(bytes2, offset2 + 32, z + w[1], (y += v[0] * 9L + LittleEndianByteArray.load64(bytes2, offset2 + 40)) + LittleEndianByteArray.load64(bytes2, offset2 + 16), w);
        return FarmHashFingerprint64.hashLength16(FarmHashFingerprint64.hashLength16(v[0], w[0], mul) + FarmHashFingerprint64.shiftMix(y) * -4348849565147123417L + x, FarmHashFingerprint64.hashLength16(v[1], w[1], mul) + z, mul);
    }
}

