/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.gson.internal.bind;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hbase.thirdparty.com.google.gson.Gson;
import org.apache.hbase.thirdparty.com.google.gson.JsonElement;
import org.apache.hbase.thirdparty.com.google.gson.JsonPrimitive;
import org.apache.hbase.thirdparty.com.google.gson.JsonSyntaxException;
import org.apache.hbase.thirdparty.com.google.gson.TypeAdapter;
import org.apache.hbase.thirdparty.com.google.gson.TypeAdapterFactory;
import org.apache.hbase.thirdparty.com.google.gson.internal.$Gson$Types;
import org.apache.hbase.thirdparty.com.google.gson.internal.ConstructorConstructor;
import org.apache.hbase.thirdparty.com.google.gson.internal.JsonReaderInternalAccess;
import org.apache.hbase.thirdparty.com.google.gson.internal.ObjectConstructor;
import org.apache.hbase.thirdparty.com.google.gson.internal.Streams;
import org.apache.hbase.thirdparty.com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import org.apache.hbase.thirdparty.com.google.gson.internal.bind.TypeAdapters;
import org.apache.hbase.thirdparty.com.google.gson.reflect.TypeToken;
import org.apache.hbase.thirdparty.com.google.gson.stream.JsonReader;
import org.apache.hbase.thirdparty.com.google.gson.stream.JsonToken;
import org.apache.hbase.thirdparty.com.google.gson.stream.JsonWriter;

public final class MapTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    final boolean complexMapKeySerialization;

    public MapTypeAdapterFactory(ConstructorConstructor constructorConstructor, boolean complexMapKeySerialization) {
        this.constructorConstructor = constructorConstructor;
        this.complexMapKeySerialization = complexMapKeySerialization;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type2 = typeToken.getType();
        Class<T> rawType = typeToken.getRawType();
        if (!Map.class.isAssignableFrom(rawType)) {
            return null;
        }
        Class<?> rawTypeOfSrc = $Gson$Types.getRawType(type2);
        Type[] keyAndValueTypes = $Gson$Types.getMapKeyAndValueTypes(type2, rawTypeOfSrc);
        TypeAdapter<?> keyAdapter = this.getKeyAdapter(gson, keyAndValueTypes[0]);
        TypeAdapter<?> valueAdapter = gson.getAdapter(TypeToken.get(keyAndValueTypes[1]));
        ObjectConstructor<T> constructor2 = this.constructorConstructor.get(typeToken);
        Adapter result2 = new Adapter(gson, keyAndValueTypes[0], keyAdapter, keyAndValueTypes[1], valueAdapter, constructor2);
        return result2;
    }

    private TypeAdapter<?> getKeyAdapter(Gson context, Type keyType) {
        return keyType == Boolean.TYPE || keyType == Boolean.class ? TypeAdapters.BOOLEAN_AS_STRING : context.getAdapter(TypeToken.get(keyType));
    }

    private final class Adapter<K, V>
    extends TypeAdapter<Map<K, V>> {
        private final TypeAdapter<K> keyTypeAdapter;
        private final TypeAdapter<V> valueTypeAdapter;
        private final ObjectConstructor<? extends Map<K, V>> constructor;

        public Adapter(Gson context, Type keyType, TypeAdapter<K> keyTypeAdapter, Type valueType, TypeAdapter<V> valueTypeAdapter, ObjectConstructor<? extends Map<K, V>> constructor2) {
            this.keyTypeAdapter = new TypeAdapterRuntimeTypeWrapper<K>(context, keyTypeAdapter, keyType);
            this.valueTypeAdapter = new TypeAdapterRuntimeTypeWrapper<V>(context, valueTypeAdapter, valueType);
            this.constructor = constructor2;
        }

        @Override
        public Map<K, V> read(JsonReader in) throws IOException {
            JsonToken peek2 = in.peek();
            if (peek2 == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            Map<K, V> map = this.constructor.construct();
            if (peek2 == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    in.beginArray();
                    K key2 = this.keyTypeAdapter.read(in);
                    V value2 = this.valueTypeAdapter.read(in);
                    V replaced = map.put(key2, value2);
                    if (replaced != null) {
                        throw new JsonSyntaxException("duplicate key: " + key2);
                    }
                    in.endArray();
                }
                in.endArray();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    V value3;
                    JsonReaderInternalAccess.INSTANCE.promoteNameToValue(in);
                    K key3 = this.keyTypeAdapter.read(in);
                    V replaced = map.put(key3, value3 = this.valueTypeAdapter.read(in));
                    if (replaced == null) continue;
                    throw new JsonSyntaxException("duplicate key: " + key3);
                }
                in.endObject();
            }
            return map;
        }

        @Override
        public void write(JsonWriter out, Map<K, V> map) throws IOException {
            JsonElement keyElement;
            if (map == null) {
                out.nullValue();
                return;
            }
            if (!MapTypeAdapterFactory.this.complexMapKeySerialization) {
                out.beginObject();
                for (Map.Entry<K, V> entry : map.entrySet()) {
                    out.name(String.valueOf(entry.getKey()));
                    this.valueTypeAdapter.write(out, entry.getValue());
                }
                out.endObject();
                return;
            }
            boolean hasComplexKeys = false;
            ArrayList<JsonElement> keys2 = new ArrayList<JsonElement>(map.size());
            ArrayList<V> values = new ArrayList<V>(map.size());
            for (Map.Entry<K, V> entry : map.entrySet()) {
                keyElement = this.keyTypeAdapter.toJsonTree(entry.getKey());
                keys2.add(keyElement);
                values.add(entry.getValue());
                hasComplexKeys |= keyElement.isJsonArray() || keyElement.isJsonObject();
            }
            if (hasComplexKeys) {
                out.beginArray();
                int size2 = keys2.size();
                for (int i2 = 0; i2 < size2; ++i2) {
                    out.beginArray();
                    Streams.write((JsonElement)keys2.get(i2), out);
                    this.valueTypeAdapter.write(out, values.get(i2));
                    out.endArray();
                }
                out.endArray();
            } else {
                out.beginObject();
                int size3 = keys2.size();
                for (int i3 = 0; i3 < size3; ++i3) {
                    keyElement = (JsonElement)keys2.get(i3);
                    out.name(this.keyToString(keyElement));
                    this.valueTypeAdapter.write(out, values.get(i3));
                }
                out.endObject();
            }
        }

        private String keyToString(JsonElement keyElement) {
            if (keyElement.isJsonPrimitive()) {
                JsonPrimitive primitive = keyElement.getAsJsonPrimitive();
                if (primitive.isNumber()) {
                    return String.valueOf(primitive.getAsNumber());
                }
                if (primitive.isBoolean()) {
                    return Boolean.toString(primitive.getAsBoolean());
                }
                if (primitive.isString()) {
                    return primitive.getAsString();
                }
                throw new AssertionError();
            }
            if (keyElement.isJsonNull()) {
                return "null";
            }
            throw new AssertionError();
        }
    }
}

