/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.protobuf;

import java.nio.ByteBuffer;
import org.apache.hbase.thirdparty.com.google.protobuf.Internal;

abstract class AllocatedBuffer {
    AllocatedBuffer() {
    }

    public abstract boolean hasNioBuffer();

    public abstract boolean hasArray();

    public abstract ByteBuffer nioBuffer();

    public abstract byte[] array();

    public abstract int arrayOffset();

    public abstract int position();

    public abstract AllocatedBuffer position(int var1);

    public abstract int limit();

    public abstract int remaining();

    public static AllocatedBuffer wrap(byte[] bytes2) {
        return AllocatedBuffer.wrapNoCheck(bytes2, 0, bytes2.length);
    }

    public static AllocatedBuffer wrap(byte[] bytes2, int offset2, int length2) {
        if (offset2 < 0 || length2 < 0 || offset2 + length2 > bytes2.length) {
            throw new IndexOutOfBoundsException(String.format("bytes.length=%d, offset=%d, length=%d", bytes2.length, offset2, length2));
        }
        return AllocatedBuffer.wrapNoCheck(bytes2, offset2, length2);
    }

    public static AllocatedBuffer wrap(final ByteBuffer buffer) {
        Internal.checkNotNull(buffer, "buffer");
        return new AllocatedBuffer(){

            @Override
            public boolean hasNioBuffer() {
                return true;
            }

            @Override
            public ByteBuffer nioBuffer() {
                return buffer;
            }

            @Override
            public boolean hasArray() {
                return buffer.hasArray();
            }

            @Override
            public byte[] array() {
                return buffer.array();
            }

            @Override
            public int arrayOffset() {
                return buffer.arrayOffset();
            }

            @Override
            public int position() {
                return buffer.position();
            }

            @Override
            public AllocatedBuffer position(int position) {
                buffer.position(position);
                return this;
            }

            @Override
            public int limit() {
                return buffer.limit();
            }

            @Override
            public int remaining() {
                return buffer.remaining();
            }
        };
    }

    private static AllocatedBuffer wrapNoCheck(final byte[] bytes2, final int offset2, final int length2) {
        return new AllocatedBuffer(){
            private int position;

            @Override
            public boolean hasNioBuffer() {
                return false;
            }

            @Override
            public ByteBuffer nioBuffer() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasArray() {
                return true;
            }

            @Override
            public byte[] array() {
                return bytes2;
            }

            @Override
            public int arrayOffset() {
                return offset2;
            }

            @Override
            public int position() {
                return this.position;
            }

            @Override
            public AllocatedBuffer position(int position) {
                if (position < 0 || position > length2) {
                    throw new IllegalArgumentException("Invalid position: " + position);
                }
                this.position = position;
                return this;
            }

            @Override
            public int limit() {
                return length2;
            }

            @Override
            public int remaining() {
                return length2 - this.position;
            }
        };
    }
}

