/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.protobuf.util;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hbase.thirdparty.com.google.common.base.CaseFormat;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.apache.hbase.thirdparty.com.google.common.base.Optional;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.hbase.thirdparty.com.google.common.primitives.Ints;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.FieldMask;
import org.apache.hbase.thirdparty.com.google.protobuf.Internal;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.util.FieldMaskTree;

public final class FieldMaskUtil {
    private static final String FIELD_PATH_SEPARATOR = ",";
    private static final String FIELD_PATH_SEPARATOR_REGEX = ",";
    private static final String FIELD_SEPARATOR_REGEX = "\\.";

    private FieldMaskUtil() {
    }

    public static String toString(FieldMask fieldMask) {
        StringBuilder result2 = new StringBuilder();
        boolean first2 = true;
        for (String value2 : fieldMask.getPathsList()) {
            if (value2.isEmpty()) continue;
            if (first2) {
                first2 = false;
            } else {
                result2.append(",");
            }
            result2.append(value2);
        }
        return result2.toString();
    }

    public static FieldMask fromString(String value2) {
        return FieldMaskUtil.fromStringList(Arrays.asList(value2.split(",")));
    }

    public static FieldMask fromString(Class<? extends Message> type2, String value2) {
        return FieldMaskUtil.fromStringList(type2, Arrays.asList(value2.split(",")));
    }

    public static FieldMask fromStringList(Class<? extends Message> type2, Iterable<String> paths) {
        return FieldMaskUtil.fromStringList(Internal.getDefaultInstance(type2).getDescriptorForType(), paths);
    }

    public static FieldMask fromStringList(Descriptors.Descriptor descriptor, Iterable<String> paths) {
        return FieldMaskUtil.fromStringList(Optional.of(descriptor), paths);
    }

    public static FieldMask fromStringList(Iterable<String> paths) {
        return FieldMaskUtil.fromStringList(Optional.absent(), paths);
    }

    private static FieldMask fromStringList(Optional<Descriptors.Descriptor> descriptor, Iterable<String> paths) {
        FieldMask.Builder builder = FieldMask.newBuilder();
        for (String path2 : paths) {
            if (path2.isEmpty()) continue;
            if (descriptor.isPresent() && !FieldMaskUtil.isValid(descriptor.get(), path2)) {
                throw new IllegalArgumentException(path2 + " is not a valid path for " + descriptor.get().getFullName());
            }
            builder.addPaths(path2);
        }
        return builder.build();
    }

    public static FieldMask fromFieldNumbers(Class<? extends Message> type2, int ... fieldNumbers) {
        return FieldMaskUtil.fromFieldNumbers(type2, Ints.asList(fieldNumbers));
    }

    public static FieldMask fromFieldNumbers(Class<? extends Message> type2, Iterable<Integer> fieldNumbers) {
        Descriptors.Descriptor descriptor = Internal.getDefaultInstance(type2).getDescriptorForType();
        FieldMask.Builder builder = FieldMask.newBuilder();
        for (Integer fieldNumber : fieldNumbers) {
            Descriptors.FieldDescriptor field2 = descriptor.findFieldByNumber(fieldNumber);
            Preconditions.checkArgument(field2 != null, String.format("%s is not a valid field number for %s.", fieldNumber, type2));
            builder.addPaths(field2.getName());
        }
        return builder.build();
    }

    public static String toJsonString(FieldMask fieldMask) {
        ArrayList<String> paths = new ArrayList<String>(fieldMask.getPathsCount());
        for (String path2 : fieldMask.getPathsList()) {
            if (path2.isEmpty()) continue;
            paths.add(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, path2));
        }
        return Joiner.on(",").join(paths);
    }

    public static FieldMask fromJsonString(String value2) {
        Iterable<String> paths = Splitter.on(",").split(value2);
        FieldMask.Builder builder = FieldMask.newBuilder();
        for (String path2 : paths) {
            if (path2.isEmpty()) continue;
            builder.addPaths(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, path2));
        }
        return builder.build();
    }

    public static boolean isValid(Class<? extends Message> type2, FieldMask fieldMask) {
        Descriptors.Descriptor descriptor = Internal.getDefaultInstance(type2).getDescriptorForType();
        return FieldMaskUtil.isValid(descriptor, fieldMask);
    }

    public static boolean isValid(Descriptors.Descriptor descriptor, FieldMask fieldMask) {
        for (String path2 : fieldMask.getPathsList()) {
            if (FieldMaskUtil.isValid(descriptor, path2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(Class<? extends Message> type2, String path2) {
        Descriptors.Descriptor descriptor = Internal.getDefaultInstance(type2).getDescriptorForType();
        return FieldMaskUtil.isValid(descriptor, path2);
    }

    public static boolean isValid(Descriptors.Descriptor descriptor, String path2) {
        String[] parts = path2.split(FIELD_SEPARATOR_REGEX);
        if (parts.length == 0) {
            return false;
        }
        for (String name2 : parts) {
            if (descriptor == null) {
                return false;
            }
            Descriptors.FieldDescriptor field2 = descriptor.findFieldByName(name2);
            if (field2 == null) {
                return false;
            }
            descriptor = !field2.isRepeated() && field2.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? field2.getMessageType() : null;
        }
        return true;
    }

    public static FieldMask normalize(FieldMask mask) {
        return new FieldMaskTree(mask).toFieldMask();
    }

    public static FieldMask union(FieldMask firstMask, FieldMask secondMask, FieldMask ... otherMasks) {
        FieldMaskTree maskTree = new FieldMaskTree(firstMask).mergeFromFieldMask(secondMask);
        for (FieldMask mask : otherMasks) {
            maskTree.mergeFromFieldMask(mask);
        }
        return maskTree.toFieldMask();
    }

    public static FieldMask subtract(FieldMask firstMask, FieldMask secondMask, FieldMask ... otherMasks) {
        FieldMaskTree maskTree = new FieldMaskTree(firstMask).removeFromFieldMask(secondMask);
        for (FieldMask mask : otherMasks) {
            maskTree.removeFromFieldMask(mask);
        }
        return maskTree.toFieldMask();
    }

    public static FieldMask intersection(FieldMask mask1, FieldMask mask2) {
        FieldMaskTree tree = new FieldMaskTree(mask1);
        FieldMaskTree result2 = new FieldMaskTree();
        for (String path2 : mask2.getPathsList()) {
            tree.intersectFieldPath(path2, result2);
        }
        return result2.toFieldMask();
    }

    public static void merge(FieldMask mask, Message source2, Message.Builder destination, MergeOptions options2) {
        new FieldMaskTree(mask).merge(source2, destination, options2);
    }

    public static void merge(FieldMask mask, Message source2, Message.Builder destination) {
        FieldMaskUtil.merge(mask, source2, destination, new MergeOptions());
    }

    public static final class MergeOptions {
        private boolean replaceMessageFields = false;
        private boolean replaceRepeatedFields = false;
        private boolean replacePrimitiveFields = false;

        public boolean replaceMessageFields() {
            return this.replaceMessageFields;
        }

        public boolean replaceRepeatedFields() {
            return this.replaceRepeatedFields;
        }

        public boolean replacePrimitiveFields() {
            return this.replacePrimitiveFields;
        }

        @CanIgnoreReturnValue
        public MergeOptions setReplaceMessageFields(boolean value2) {
            this.replaceMessageFields = value2;
            return this;
        }

        @CanIgnoreReturnValue
        public MergeOptions setReplaceRepeatedFields(boolean value2) {
            this.replaceRepeatedFields = value2;
            return this;
        }

        @CanIgnoreReturnValue
        public MergeOptions setReplacePrimitiveFields(boolean value2) {
            this.replacePrimitiveFields = value2;
            return this;
        }
    }
}

