/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.dns;

import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DefaultDnsPtrRecord;
import org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DefaultDnsQuestion;
import org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DefaultDnsRawRecord;
import org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DnsCodecUtil;
import org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DnsQuestion;
import org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DnsRecord;
import org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DnsRecordDecoder;
import org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DnsRecordType;

public class DefaultDnsRecordDecoder
implements DnsRecordDecoder {
    static final String ROOT = ".";

    protected DefaultDnsRecordDecoder() {
    }

    @Override
    public final DnsQuestion decodeQuestion(ByteBuf in) throws Exception {
        String name2 = DefaultDnsRecordDecoder.decodeName(in);
        DnsRecordType type2 = DnsRecordType.valueOf(in.readUnsignedShort());
        int qClass = in.readUnsignedShort();
        return new DefaultDnsQuestion(name2, type2, qClass);
    }

    @Override
    public final <T extends DnsRecord> T decodeRecord(ByteBuf in) throws Exception {
        int startOffset = in.readerIndex();
        String name2 = DefaultDnsRecordDecoder.decodeName(in);
        int endOffset = in.writerIndex();
        if (endOffset - in.readerIndex() < 10) {
            in.readerIndex(startOffset);
            return null;
        }
        DnsRecordType type2 = DnsRecordType.valueOf(in.readUnsignedShort());
        int aClass = in.readUnsignedShort();
        long ttl = in.readUnsignedInt();
        int length2 = in.readUnsignedShort();
        int offset2 = in.readerIndex();
        if (endOffset - offset2 < length2) {
            in.readerIndex(startOffset);
            return null;
        }
        DnsRecord record = this.decodeRecord(name2, type2, aClass, ttl, in, offset2, length2);
        in.readerIndex(offset2 + length2);
        return (T)record;
    }

    protected DnsRecord decodeRecord(String name2, DnsRecordType type2, int dnsClass, long timeToLive, ByteBuf in, int offset2, int length2) throws Exception {
        if (type2 == DnsRecordType.PTR) {
            return new DefaultDnsPtrRecord(name2, dnsClass, timeToLive, this.decodeName0(in.duplicate().setIndex(offset2, offset2 + length2)));
        }
        if (type2 == DnsRecordType.CNAME || type2 == DnsRecordType.NS) {
            return new DefaultDnsRawRecord(name2, type2, dnsClass, timeToLive, DnsCodecUtil.decompressDomainName(in.duplicate().setIndex(offset2, offset2 + length2)));
        }
        return new DefaultDnsRawRecord(name2, type2, dnsClass, timeToLive, in.retainedDuplicate().setIndex(offset2, offset2 + length2));
    }

    protected String decodeName0(ByteBuf in) {
        return DefaultDnsRecordDecoder.decodeName(in);
    }

    public static String decodeName(ByteBuf in) {
        return DnsCodecUtil.decodeDomainName(in);
    }
}

