/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.dns;

import org.apache.hbase.thirdparty.io.netty.channel.AddressedEnvelope;
import org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DnsMessage;
import org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DnsQuery;
import org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DnsResponse;
import org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DnsSection;
import org.apache.hbase.thirdparty.io.netty.util.internal.StringUtil;

final class DnsMessageUtil {
    static StringBuilder appendQuery(StringBuilder buf, DnsQuery query) {
        DnsMessageUtil.appendQueryHeader(buf, query);
        DnsMessageUtil.appendAllRecords(buf, query);
        return buf;
    }

    static StringBuilder appendResponse(StringBuilder buf, DnsResponse response) {
        DnsMessageUtil.appendResponseHeader(buf, response);
        DnsMessageUtil.appendAllRecords(buf, response);
        return buf;
    }

    static StringBuilder appendRecordClass(StringBuilder buf, int dnsClass) {
        String name2;
        switch (dnsClass &= 0xFFFF) {
            case 1: {
                name2 = "IN";
                break;
            }
            case 2: {
                name2 = "CSNET";
                break;
            }
            case 3: {
                name2 = "CHAOS";
                break;
            }
            case 4: {
                name2 = "HESIOD";
                break;
            }
            case 254: {
                name2 = "NONE";
                break;
            }
            case 255: {
                name2 = "ANY";
                break;
            }
            default: {
                name2 = null;
            }
        }
        if (name2 != null) {
            buf.append(name2);
        } else {
            buf.append("UNKNOWN(").append(dnsClass).append(')');
        }
        return buf;
    }

    private static void appendQueryHeader(StringBuilder buf, DnsQuery msg) {
        buf.append(StringUtil.simpleClassName(msg)).append('(');
        DnsMessageUtil.appendAddresses(buf, msg).append(msg.id()).append(", ").append(msg.opCode());
        if (msg.isRecursionDesired()) {
            buf.append(", RD");
        }
        if (msg.z() != 0) {
            buf.append(", Z: ").append(msg.z());
        }
        buf.append(')');
    }

    private static void appendResponseHeader(StringBuilder buf, DnsResponse msg) {
        buf.append(StringUtil.simpleClassName(msg)).append('(');
        DnsMessageUtil.appendAddresses(buf, msg).append(msg.id()).append(", ").append(msg.opCode()).append(", ").append(msg.code()).append(',');
        boolean hasComma = true;
        if (msg.isRecursionDesired()) {
            hasComma = false;
            buf.append(" RD");
        }
        if (msg.isAuthoritativeAnswer()) {
            hasComma = false;
            buf.append(" AA");
        }
        if (msg.isTruncated()) {
            hasComma = false;
            buf.append(" TC");
        }
        if (msg.isRecursionAvailable()) {
            hasComma = false;
            buf.append(" RA");
        }
        if (msg.z() != 0) {
            if (!hasComma) {
                buf.append(',');
            }
            buf.append(" Z: ").append(msg.z());
        }
        if (hasComma) {
            buf.setCharAt(buf.length() - 1, ')');
        } else {
            buf.append(')');
        }
    }

    private static StringBuilder appendAddresses(StringBuilder buf, DnsMessage msg) {
        if (!(msg instanceof AddressedEnvelope)) {
            return buf;
        }
        AddressedEnvelope envelope = (AddressedEnvelope)((Object)msg);
        Object addr2 = envelope.sender();
        if (addr2 != null) {
            buf.append("from: ").append(addr2).append(", ");
        }
        if ((addr2 = envelope.recipient()) != null) {
            buf.append("to: ").append(addr2).append(", ");
        }
        return buf;
    }

    private static void appendAllRecords(StringBuilder buf, DnsMessage msg) {
        DnsMessageUtil.appendRecords(buf, msg, DnsSection.QUESTION);
        DnsMessageUtil.appendRecords(buf, msg, DnsSection.ANSWER);
        DnsMessageUtil.appendRecords(buf, msg, DnsSection.AUTHORITY);
        DnsMessageUtil.appendRecords(buf, msg, DnsSection.ADDITIONAL);
    }

    private static void appendRecords(StringBuilder buf, DnsMessage message2, DnsSection section) {
        int count2 = message2.count(section);
        for (int i2 = 0; i2 < count2; ++i2) {
            buf.append(StringUtil.NEWLINE).append('\t').append(message2.recordAt(section, i2));
        }
    }

    private DnsMessageUtil() {
    }
}

