/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.resolver.dns;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import org.apache.hbase.thirdparty.io.netty.resolver.dns.DnsServerAddressStream;

final class SequentialDnsServerAddressStream
implements DnsServerAddressStream {
    private final List<? extends InetSocketAddress> addresses;
    private int i;

    SequentialDnsServerAddressStream(List<? extends InetSocketAddress> addresses, int startIdx) {
        this.addresses = addresses;
        this.i = startIdx;
    }

    @Override
    public InetSocketAddress next() {
        int i2 = this.i;
        InetSocketAddress next2 = this.addresses.get(i2);
        this.i = ++i2 < this.addresses.size() ? i2 : 0;
        return next2;
    }

    @Override
    public int size() {
        return this.addresses.size();
    }

    @Override
    public SequentialDnsServerAddressStream duplicate() {
        return new SequentialDnsServerAddressStream(this.addresses, this.i);
    }

    public String toString() {
        return SequentialDnsServerAddressStream.toString("sequential", this.i, this.addresses);
    }

    static String toString(String type2, int index2, Collection<? extends InetSocketAddress> addresses) {
        StringBuilder buf = new StringBuilder(type2.length() + 2 + addresses.size() * 16);
        buf.append(type2).append("(index: ").append(index2);
        buf.append(", addrs: (");
        for (InetSocketAddress inetSocketAddress : addresses) {
            buf.append(inetSocketAddress).append(", ");
        }
        buf.setLength(buf.length() - 2);
        buf.append("))");
        return buf.toString();
    }
}

