/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.util;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hbase.thirdparty.io.netty.util.Constant;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.PlatformDependent;

public abstract class ConstantPool<T extends Constant<T>> {
    private final ConcurrentMap<String, T> constants = PlatformDependent.newConcurrentHashMap();
    private final AtomicInteger nextId = new AtomicInteger(1);

    public T valueOf(Class<?> firstNameComponent, String secondNameComponent) {
        return this.valueOf(ObjectUtil.checkNotNull(firstNameComponent, "firstNameComponent").getName() + '#' + ObjectUtil.checkNotNull(secondNameComponent, "secondNameComponent"));
    }

    public T valueOf(String name2) {
        return this.getOrCreate(ObjectUtil.checkNonEmpty(name2, "name"));
    }

    private T getOrCreate(String name2) {
        T tempConstant;
        Constant constant = (Constant)this.constants.get(name2);
        if (constant == null && (constant = (Constant)this.constants.putIfAbsent(name2, tempConstant = this.newConstant(this.nextId(), name2))) == null) {
            return tempConstant;
        }
        return (T)constant;
    }

    public boolean exists(String name2) {
        return this.constants.containsKey(ObjectUtil.checkNonEmpty(name2, "name"));
    }

    public T newInstance(String name2) {
        return this.createOrThrow(ObjectUtil.checkNonEmpty(name2, "name"));
    }

    private T createOrThrow(String name2) {
        T tempConstant;
        Constant constant = (Constant)this.constants.get(name2);
        if (constant == null && (constant = (Constant)this.constants.putIfAbsent(name2, tempConstant = this.newConstant(this.nextId(), name2))) == null) {
            return tempConstant;
        }
        throw new IllegalArgumentException(String.format("'%s' is already in use", name2));
    }

    protected abstract T newConstant(int var1, String var2);

    @Deprecated
    public final int nextId() {
        return this.nextId.getAndIncrement();
    }
}

