/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.htrace.core.Tracer;

public class TraceExecutorService
implements ExecutorService {
    private final Tracer tracer;
    private final String scopeName;
    private final ExecutorService impl;

    TraceExecutorService(Tracer tracer, String scopeName, ExecutorService impl2) {
        this.tracer = tracer;
        this.scopeName = scopeName;
        this.impl = impl2;
    }

    @Override
    public void execute(Runnable command) {
        this.impl.execute(this.wrap(command));
    }

    @Override
    public void shutdown() {
        this.impl.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.impl.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.impl.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.impl.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout2, TimeUnit unit) throws InterruptedException {
        return this.impl.awaitTermination(timeout2, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.impl.submit(this.wrap(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result2) {
        return this.impl.submit(this.wrap(task), result2);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.impl.submit(this.wrap(task));
    }

    Runnable wrap(Runnable runnable) {
        return this.tracer.wrap(runnable, this.scopeName);
    }

    <V> Callable<V> wrap(Callable<V> callable) {
        return this.tracer.wrap(callable, this.scopeName);
    }

    private <T> Collection<? extends Callable<T>> wrapCollection(Collection<? extends Callable<T>> tasks) {
        ArrayList<Callable<T>> result2 = new ArrayList<Callable<T>>();
        for (Callable<T> task : tasks) {
            result2.add(this.wrap(task));
        }
        return result2;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.impl.invokeAll(this.wrapCollection(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout2, TimeUnit unit) throws InterruptedException {
        return this.impl.invokeAll(this.wrapCollection(tasks), timeout2, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.impl.invokeAny(this.wrapCollection(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout2, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.impl.invokeAny(this.wrapCollection(tasks), timeout2, unit);
    }
}

