/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.fasterxml.jackson.databind.deser.impl;

import java.io.IOException;
import org.apache.htrace.shaded.fasterxml.jackson.core.JsonParser;
import org.apache.htrace.shaded.fasterxml.jackson.databind.DeserializationContext;
import org.apache.htrace.shaded.fasterxml.jackson.databind.deser.SettableAnyProperty;
import org.apache.htrace.shaded.fasterxml.jackson.databind.deser.SettableBeanProperty;
import org.apache.htrace.shaded.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import org.apache.htrace.shaded.fasterxml.jackson.databind.deser.impl.PropertyValue;
import org.apache.htrace.shaded.fasterxml.jackson.databind.deser.impl.ReadableObjectId;

public final class PropertyValueBuffer {
    protected final JsonParser _parser;
    protected final DeserializationContext _context;
    protected final Object[] _creatorParameters;
    protected final ObjectIdReader _objectIdReader;
    private int _paramsNeeded;
    private PropertyValue _buffered;
    private Object _idValue;

    public PropertyValueBuffer(JsonParser jp, DeserializationContext ctxt, int paramCount, ObjectIdReader oir) {
        this._parser = jp;
        this._context = ctxt;
        this._paramsNeeded = paramCount;
        this._objectIdReader = oir;
        this._creatorParameters = new Object[paramCount];
    }

    public void inject(SettableBeanProperty[] injectableProperties) {
        for (SettableBeanProperty prop : injectableProperties) {
            if (prop == null) continue;
            this._creatorParameters[i] = this._context.findInjectableValue(prop.getInjectableValueId(), prop, null);
        }
    }

    protected final Object[] getParameters(Object[] defaults) {
        if (defaults != null) {
            int len = this._creatorParameters.length;
            for (int i2 = 0; i2 < len; ++i2) {
                Object value2;
                if (this._creatorParameters[i2] != null || (value2 = defaults[i2]) == null) continue;
                this._creatorParameters[i2] = value2;
            }
        }
        return this._creatorParameters;
    }

    public boolean readIdProperty(String propName) throws IOException {
        if (this._objectIdReader != null && propName.equals(this._objectIdReader.propertyName.getSimpleName())) {
            this._idValue = this._objectIdReader.readObjectReference(this._parser, this._context);
            return true;
        }
        return false;
    }

    public Object handleIdValue(DeserializationContext ctxt, Object bean) throws IOException {
        if (this._objectIdReader != null && this._idValue != null) {
            ReadableObjectId roid = ctxt.findObjectId(this._idValue, this._objectIdReader.generator, this._objectIdReader.resolver);
            roid.bindItem(bean);
            SettableBeanProperty idProp = this._objectIdReader.idProperty;
            if (idProp != null) {
                return idProp.setAndReturn(bean, this._idValue);
            }
        }
        return bean;
    }

    protected PropertyValue buffered() {
        return this._buffered;
    }

    public boolean isComplete() {
        return this._paramsNeeded <= 0;
    }

    public boolean assignParameter(int index2, Object value2) {
        this._creatorParameters[index2] = value2;
        return --this._paramsNeeded <= 0;
    }

    public void bufferProperty(SettableBeanProperty prop, Object value2) {
        this._buffered = new PropertyValue.Regular(this._buffered, value2, prop);
    }

    public void bufferAnyProperty(SettableAnyProperty prop, String propName, Object value2) {
        this._buffered = new PropertyValue.Any(this._buffered, value2, prop, propName);
    }

    public void bufferMapProperty(Object key2, Object value2) {
        this._buffered = new PropertyValue.Map(this._buffered, value2, key2);
    }
}

