/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import org.apache.htrace.shaded.fasterxml.jackson.core.Base64Variants;
import org.apache.htrace.shaded.fasterxml.jackson.databind.DeserializationContext;
import org.apache.htrace.shaded.fasterxml.jackson.databind.deser.std.FromStringDeserializer;

public class UUIDDeserializer
extends FromStringDeserializer<UUID> {
    private static final long serialVersionUID = 1L;
    static final int[] HEX_DIGITS;

    public UUIDDeserializer() {
        super(UUID.class);
    }

    @Override
    protected UUID _deserialize(String id2, DeserializationContext ctxt) throws IOException {
        if (id2.length() != 36) {
            if (id2.length() == 24) {
                byte[] stuff = Base64Variants.getDefaultVariant().decode(id2);
                return this._fromBytes(stuff, ctxt);
            }
            this._badFormat(id2);
        }
        if (id2.charAt(8) != '-' || id2.charAt(13) != '-' || id2.charAt(18) != '-' || id2.charAt(23) != '-') {
            this._badFormat(id2);
        }
        long l1 = UUIDDeserializer.intFromChars(id2, 0);
        long l2 = (long)UUIDDeserializer.shortFromChars(id2, 9) << 16;
        long hi = (l1 <<= 32) + (l2 |= (long)UUIDDeserializer.shortFromChars(id2, 14));
        int i1 = UUIDDeserializer.shortFromChars(id2, 19) << 16 | UUIDDeserializer.shortFromChars(id2, 24);
        l1 = i1;
        l2 = UUIDDeserializer.intFromChars(id2, 28);
        l2 = l2 << 32 >>> 32;
        long lo = (l1 <<= 32) | l2;
        return new UUID(hi, lo);
    }

    @Override
    protected UUID _deserializeEmbedded(Object ob, DeserializationContext ctxt) throws IOException {
        if (ob instanceof byte[]) {
            return this._fromBytes((byte[])ob, ctxt);
        }
        super._deserializeEmbedded(ob, ctxt);
        return null;
    }

    private void _badFormat(String uuidStr) {
        throw new NumberFormatException("UUID has to be represented by the standard 36-char representation");
    }

    static int intFromChars(String str, int index2) {
        return (UUIDDeserializer.byteFromChars(str, index2) << 24) + (UUIDDeserializer.byteFromChars(str, index2 + 2) << 16) + (UUIDDeserializer.byteFromChars(str, index2 + 4) << 8) + UUIDDeserializer.byteFromChars(str, index2 + 6);
    }

    static int shortFromChars(String str, int index2) {
        return (UUIDDeserializer.byteFromChars(str, index2) << 8) + UUIDDeserializer.byteFromChars(str, index2 + 2);
    }

    static int byteFromChars(String str, int index2) {
        int hex2;
        char c1 = str.charAt(index2);
        char c2 = str.charAt(index2 + 1);
        if (c1 <= '\u007f' && c2 <= '\u007f' && (hex2 = HEX_DIGITS[c1] << 4 | HEX_DIGITS[c2]) >= 0) {
            return hex2;
        }
        if (c1 > '\u007f' || HEX_DIGITS[c1] < 0) {
            return UUIDDeserializer._badChar(str, index2, c1);
        }
        return UUIDDeserializer._badChar(str, index2 + 1, c2);
    }

    static int _badChar(String uuidStr, int index2, char c) {
        throw new NumberFormatException("Non-hex character '" + c + "', not valid character for a UUID String" + "' (value 0x" + Integer.toHexString(c) + ") for UUID String \"" + uuidStr + "\"");
    }

    private UUID _fromBytes(byte[] bytes2, DeserializationContext ctxt) throws IOException {
        if (bytes2.length != 16) {
            ctxt.mappingException("Can only construct UUIDs from byte[16]; got " + bytes2.length + " bytes");
        }
        return new UUID(UUIDDeserializer._long(bytes2, 0), UUIDDeserializer._long(bytes2, 8));
    }

    private static long _long(byte[] b, int offset2) {
        long l1 = (long)UUIDDeserializer._int(b, offset2) << 32;
        long l2 = UUIDDeserializer._int(b, offset2 + 4);
        l2 = l2 << 32 >>> 32;
        return l1 | l2;
    }

    private static int _int(byte[] b, int offset2) {
        return b[offset2] << 24 | (b[offset2 + 1] & 0xFF) << 16 | (b[offset2 + 2] & 0xFF) << 8 | b[offset2 + 3] & 0xFF;
    }

    static {
        int i2;
        HEX_DIGITS = new int[127];
        Arrays.fill(HEX_DIGITS, -1);
        for (i2 = 0; i2 < 10; ++i2) {
            UUIDDeserializer.HEX_DIGITS[48 + i2] = i2;
        }
        for (i2 = 0; i2 < 6; ++i2) {
            UUIDDeserializer.HEX_DIGITS[97 + i2] = 10 + i2;
            UUIDDeserializer.HEX_DIGITS[65 + i2] = 10 + i2;
        }
    }
}

