/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.shaded.fasterxml.jackson.databind.module;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.htrace.shaded.fasterxml.jackson.databind.BeanDescription;
import org.apache.htrace.shaded.fasterxml.jackson.databind.JavaType;
import org.apache.htrace.shaded.fasterxml.jackson.databind.JsonSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.SerializationConfig;
import org.apache.htrace.shaded.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.htrace.shaded.fasterxml.jackson.databind.ser.Serializers;
import org.apache.htrace.shaded.fasterxml.jackson.databind.type.ArrayType;
import org.apache.htrace.shaded.fasterxml.jackson.databind.type.ClassKey;
import org.apache.htrace.shaded.fasterxml.jackson.databind.type.CollectionLikeType;
import org.apache.htrace.shaded.fasterxml.jackson.databind.type.CollectionType;
import org.apache.htrace.shaded.fasterxml.jackson.databind.type.MapLikeType;
import org.apache.htrace.shaded.fasterxml.jackson.databind.type.MapType;

public class SimpleSerializers
extends Serializers.Base
implements Serializable {
    private static final long serialVersionUID = 8531646511998456779L;
    protected HashMap<ClassKey, JsonSerializer<?>> _classMappings = null;
    protected HashMap<ClassKey, JsonSerializer<?>> _interfaceMappings = null;
    protected boolean _hasEnumSerializer = false;

    public SimpleSerializers() {
    }

    public SimpleSerializers(List<JsonSerializer<?>> sers) {
        this.addSerializers(sers);
    }

    public void addSerializer(JsonSerializer<?> ser) {
        Class<?> cls = ser.handledType();
        if (cls == null || cls == Object.class) {
            throw new IllegalArgumentException("JsonSerializer of type " + ser.getClass().getName() + " does not define valid handledType() -- must either register with method that takes type argument " + " or make serializer extend 'com.fasterxml.jackson.databind.ser.std.StdSerializer'");
        }
        this._addSerializer(cls, ser);
    }

    public <T> void addSerializer(Class<? extends T> type2, JsonSerializer<T> ser) {
        this._addSerializer(type2, ser);
    }

    public void addSerializers(List<JsonSerializer<?>> sers) {
        for (JsonSerializer<?> ser : sers) {
            this.addSerializer(ser);
        }
    }

    @Override
    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type2, BeanDescription beanDesc) {
        Class<?> cls = type2.getRawClass();
        ClassKey key2 = new ClassKey(cls);
        JsonSerializer<?> ser = null;
        if (cls.isInterface()) {
            if (this._interfaceMappings != null && (ser = this._interfaceMappings.get(key2)) != null) {
                return ser;
            }
        } else if (this._classMappings != null) {
            ser = this._classMappings.get(key2);
            if (ser != null) {
                return ser;
            }
            if (this._hasEnumSerializer && type2.isEnumType()) {
                key2.reset(Enum.class);
                ser = this._classMappings.get(key2);
                if (ser != null) {
                    return ser;
                }
            }
            for (Class<?> curr = cls; curr != null; curr = curr.getSuperclass()) {
                key2.reset(curr);
                ser = this._classMappings.get(key2);
                if (ser == null) continue;
                return ser;
            }
        }
        if (this._interfaceMappings != null) {
            ser = this._findInterfaceMapping(cls, key2);
            if (ser != null) {
                return ser;
            }
            if (!cls.isInterface()) {
                while ((cls = cls.getSuperclass()) != null) {
                    ser = this._findInterfaceMapping(cls, key2);
                    if (ser == null) continue;
                    return ser;
                }
            }
        }
        return null;
    }

    @Override
    public JsonSerializer<?> findArraySerializer(SerializationConfig config, ArrayType type2, BeanDescription beanDesc, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        return this.findSerializer(config, type2, beanDesc);
    }

    @Override
    public JsonSerializer<?> findCollectionSerializer(SerializationConfig config, CollectionType type2, BeanDescription beanDesc, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        return this.findSerializer(config, type2, beanDesc);
    }

    @Override
    public JsonSerializer<?> findCollectionLikeSerializer(SerializationConfig config, CollectionLikeType type2, BeanDescription beanDesc, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        return this.findSerializer(config, type2, beanDesc);
    }

    @Override
    public JsonSerializer<?> findMapSerializer(SerializationConfig config, MapType type2, BeanDescription beanDesc, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        return this.findSerializer(config, type2, beanDesc);
    }

    @Override
    public JsonSerializer<?> findMapLikeSerializer(SerializationConfig config, MapLikeType type2, BeanDescription beanDesc, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        return this.findSerializer(config, type2, beanDesc);
    }

    protected JsonSerializer<?> _findInterfaceMapping(Class<?> cls, ClassKey key2) {
        for (Class<?> iface : cls.getInterfaces()) {
            key2.reset(iface);
            JsonSerializer<?> ser = this._interfaceMappings.get(key2);
            if (ser != null) {
                return ser;
            }
            ser = this._findInterfaceMapping(iface, key2);
            if (ser == null) continue;
            return ser;
        }
        return null;
    }

    protected void _addSerializer(Class<?> cls, JsonSerializer<?> ser) {
        ClassKey key2 = new ClassKey(cls);
        if (cls.isInterface()) {
            if (this._interfaceMappings == null) {
                this._interfaceMappings = new HashMap();
            }
            this._interfaceMappings.put(key2, ser);
        } else {
            if (this._classMappings == null) {
                this._classMappings = new HashMap();
            }
            this._classMappings.put(key2, ser);
            if (cls == Enum.class) {
                this._hasEnumSerializer = true;
            }
        }
    }
}

