/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.WatchesPathReport;
import org.apache.zookeeper.server.WatchesReport;
import org.apache.zookeeper.server.WatchesSummary;
import org.apache.zookeeper.server.ZooTrace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WatchManager {
    private static final Logger LOG = LoggerFactory.getLogger(WatchManager.class);
    private final HashMap<String, HashSet<Watcher>> watchTable = new HashMap();
    private final HashMap<Watcher, HashSet<String>> watch2Paths = new HashMap();

    WatchManager() {
    }

    synchronized int size() {
        int result2 = 0;
        for (Set set : this.watchTable.values()) {
            result2 += set.size();
        }
        return result2;
    }

    synchronized void addWatch(String path2, Watcher watcher) {
        HashSet<Watcher> list2 = this.watchTable.get(path2);
        if (list2 == null) {
            list2 = new HashSet(4);
            this.watchTable.put(path2, list2);
        }
        list2.add(watcher);
        HashSet<String> paths = this.watch2Paths.get(watcher);
        if (paths == null) {
            paths = new HashSet();
            this.watch2Paths.put(watcher, paths);
        }
        paths.add(path2);
    }

    synchronized void removeWatcher(Watcher watcher) {
        HashSet<String> paths = this.watch2Paths.remove(watcher);
        if (paths == null) {
            return;
        }
        for (String p2 : paths) {
            HashSet<Watcher> list2 = this.watchTable.get(p2);
            if (list2 == null) continue;
            list2.remove(watcher);
            if (list2.size() != 0) continue;
            this.watchTable.remove(p2);
        }
    }

    Set<Watcher> triggerWatch(String path2, Watcher.Event.EventType type2) {
        return this.triggerWatch(path2, type2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Watcher> triggerWatch(String path2, Watcher.Event.EventType type2, Set<Watcher> supress) {
        HashSet<Watcher> watchers;
        WatchedEvent e = new WatchedEvent(type2, Watcher.Event.KeeperState.SyncConnected, path2);
        WatchManager watchManager = this;
        synchronized (watchManager) {
            watchers = this.watchTable.remove(path2);
            if (watchers == null || watchers.isEmpty()) {
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logTraceMessage(LOG, 64L, "No watchers for " + path2);
                }
                return null;
            }
            for (Watcher w : watchers) {
                HashSet<String> paths = this.watch2Paths.get(w);
                if (paths == null) continue;
                paths.remove(path2);
            }
        }
        for (Watcher w : watchers) {
            if (supress != null && supress.contains(w)) continue;
            w.process(e);
        }
        return watchers;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.watch2Paths.size()).append(" connections watching ").append(this.watchTable.size()).append(" paths\n");
        int total2 = 0;
        for (HashSet<String> paths : this.watch2Paths.values()) {
            total2 += paths.size();
        }
        sb.append("Total watches:").append(total2);
        return sb.toString();
    }

    synchronized void dumpWatches(PrintWriter pwriter, boolean byPath) {
        if (byPath) {
            for (Map.Entry<String, HashSet<Watcher>> e : this.watchTable.entrySet()) {
                pwriter.println(e.getKey());
                for (Watcher w : e.getValue()) {
                    pwriter.print("\t0x");
                    pwriter.print(Long.toHexString(((ServerCnxn)w).getSessionId()));
                    pwriter.print("\n");
                }
            }
        } else {
            for (Map.Entry<Watcher, HashSet<String>> e : this.watch2Paths.entrySet()) {
                pwriter.print("0x");
                pwriter.println(Long.toHexString(((ServerCnxn)e.getKey()).getSessionId()));
                for (String path2 : e.getValue()) {
                    pwriter.print("\t");
                    pwriter.println(path2);
                }
            }
        }
    }

    synchronized boolean containsWatcher(String path2, Watcher watcher) {
        HashSet<String> paths = this.watch2Paths.get(watcher);
        return paths != null && paths.contains(path2);
    }

    synchronized boolean removeWatcher(String path2, Watcher watcher) {
        HashSet<String> paths = this.watch2Paths.get(watcher);
        if (paths == null || !paths.remove(path2)) {
            return false;
        }
        HashSet<Watcher> list2 = this.watchTable.get(path2);
        if (list2 == null || !list2.remove(watcher)) {
            return false;
        }
        if (list2.size() == 0) {
            this.watchTable.remove(path2);
        }
        return true;
    }

    synchronized WatchesReport getWatches() {
        HashMap<Long, Set<String>> id2paths = new HashMap<Long, Set<String>>();
        for (Map.Entry<Watcher, HashSet<String>> e : this.watch2Paths.entrySet()) {
            Long id2 = ((ServerCnxn)e.getKey()).getSessionId();
            HashSet paths = new HashSet(e.getValue());
            id2paths.put(id2, paths);
        }
        return new WatchesReport(id2paths);
    }

    synchronized WatchesPathReport getWatchesByPath() {
        HashMap<String, Set<Long>> path2ids = new HashMap<String, Set<Long>>();
        for (Map.Entry<String, HashSet<Watcher>> e : this.watchTable.entrySet()) {
            HashSet<Long> ids = new HashSet<Long>(e.getValue().size());
            path2ids.put(e.getKey(), ids);
            for (Watcher watcher : e.getValue()) {
                ids.add(((ServerCnxn)watcher).getSessionId());
            }
        }
        return new WatchesPathReport(path2ids);
    }

    synchronized WatchesSummary getWatchesSummary() {
        int totalWatches = 0;
        for (HashSet<String> paths : this.watch2Paths.values()) {
            totalWatches += paths.size();
        }
        return new WatchesSummary(this.watch2Paths.size(), this.watchTable.size(), totalWatches);
    }
}

