/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.config;

import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.OngoingConfigOptions;
import com.datastax.oss.driver.internal.core.config.DerivedExecutionProfile;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

public interface DriverExecutionProfile
extends OngoingConfigOptions<DriverExecutionProfile> {
    public static final String DEFAULT_NAME = "default";

    @NonNull
    public String getName();

    public boolean isDefined(@NonNull DriverOption var1);

    public boolean getBoolean(@NonNull DriverOption var1);

    default public boolean getBoolean(@NonNull DriverOption option, boolean defaultValue2) {
        return this.isDefined(option) ? this.getBoolean(option) : defaultValue2;
    }

    @NonNull
    public List<Boolean> getBooleanList(@NonNull DriverOption var1);

    @Nullable
    default public List<Boolean> getBooleanList(@NonNull DriverOption option, @Nullable List<Boolean> defaultValue2) {
        return this.isDefined(option) ? this.getBooleanList(option) : defaultValue2;
    }

    public int getInt(@NonNull DriverOption var1);

    default public int getInt(@NonNull DriverOption option, int defaultValue2) {
        return this.isDefined(option) ? this.getInt(option) : defaultValue2;
    }

    @NonNull
    public List<Integer> getIntList(@NonNull DriverOption var1);

    @Nullable
    default public List<Integer> getIntList(@NonNull DriverOption option, @Nullable List<Integer> defaultValue2) {
        return this.isDefined(option) ? this.getIntList(option) : defaultValue2;
    }

    public long getLong(@NonNull DriverOption var1);

    default public long getLong(@NonNull DriverOption option, long defaultValue2) {
        return this.isDefined(option) ? this.getLong(option) : defaultValue2;
    }

    @NonNull
    public List<Long> getLongList(@NonNull DriverOption var1);

    @Nullable
    default public List<Long> getLongList(@NonNull DriverOption option, @Nullable List<Long> defaultValue2) {
        return this.isDefined(option) ? this.getLongList(option) : defaultValue2;
    }

    public double getDouble(@NonNull DriverOption var1);

    default public double getDouble(@NonNull DriverOption option, double defaultValue2) {
        return this.isDefined(option) ? this.getDouble(option) : defaultValue2;
    }

    @NonNull
    public List<Double> getDoubleList(@NonNull DriverOption var1);

    @Nullable
    default public List<Double> getDoubleList(@NonNull DriverOption option, @Nullable List<Double> defaultValue2) {
        return this.isDefined(option) ? this.getDoubleList(option) : defaultValue2;
    }

    @NonNull
    public String getString(@NonNull DriverOption var1);

    @Nullable
    default public String getString(@NonNull DriverOption option, @Nullable String defaultValue2) {
        return this.isDefined(option) ? this.getString(option) : defaultValue2;
    }

    @NonNull
    public List<String> getStringList(@NonNull DriverOption var1);

    @Nullable
    default public List<String> getStringList(@NonNull DriverOption option, @Nullable List<String> defaultValue2) {
        return this.isDefined(option) ? this.getStringList(option) : defaultValue2;
    }

    @NonNull
    public Map<String, String> getStringMap(@NonNull DriverOption var1);

    @Nullable
    default public Map<String, String> getStringMap(@NonNull DriverOption option, @Nullable Map<String, String> defaultValue2) {
        return this.isDefined(option) ? this.getStringMap(option) : defaultValue2;
    }

    public long getBytes(@NonNull DriverOption var1);

    default public long getBytes(@NonNull DriverOption option, long defaultValue2) {
        return this.isDefined(option) ? this.getBytes(option) : defaultValue2;
    }

    @NonNull
    public List<Long> getBytesList(DriverOption var1);

    @Nullable
    default public List<Long> getBytesList(DriverOption option, @Nullable List<Long> defaultValue2) {
        return this.isDefined(option) ? this.getBytesList(option) : defaultValue2;
    }

    @NonNull
    public Duration getDuration(@NonNull DriverOption var1);

    @Nullable
    default public Duration getDuration(@NonNull DriverOption option, @Nullable Duration defaultValue2) {
        return this.isDefined(option) ? this.getDuration(option) : defaultValue2;
    }

    @NonNull
    public List<Duration> getDurationList(@NonNull DriverOption var1);

    @Nullable
    default public List<Duration> getDurationList(@NonNull DriverOption option, @Nullable List<Duration> defaultValue2) {
        return this.isDefined(option) ? this.getDurationList(option) : defaultValue2;
    }

    @NonNull
    default public Object getComparisonKey(@NonNull DriverOption option) {
        String prefix = option.getPath();
        ImmutableMap.Builder childOptions = ImmutableMap.builder();
        for (Map.Entry entry : this.entrySet()) {
            if (!((String)entry.getKey()).startsWith(prefix)) continue;
            childOptions.put((String)entry.getKey(), entry.getValue());
        }
        return childOptions.build();
    }

    @NonNull
    public SortedSet<Map.Entry<String, Object>> entrySet();

    @Override
    @NonNull
    default public DriverExecutionProfile withBoolean(@NonNull DriverOption option, boolean value) {
        return DerivedExecutionProfile.with(this, option, value);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withBooleanList(@NonNull DriverOption option, @NonNull List<Boolean> value) {
        return DerivedExecutionProfile.with(this, option, value);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withInt(@NonNull DriverOption option, int value) {
        return DerivedExecutionProfile.with(this, option, value);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withIntList(@NonNull DriverOption option, @NonNull List<Integer> value) {
        return DerivedExecutionProfile.with(this, option, value);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withLong(@NonNull DriverOption option, long value) {
        return DerivedExecutionProfile.with(this, option, value);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withLongList(@NonNull DriverOption option, @NonNull List<Long> value) {
        return DerivedExecutionProfile.with(this, option, value);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withDouble(@NonNull DriverOption option, double value) {
        return DerivedExecutionProfile.with(this, option, value);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withDoubleList(@NonNull DriverOption option, @NonNull List<Double> value) {
        return DerivedExecutionProfile.with(this, option, value);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withString(@NonNull DriverOption option, @NonNull String value) {
        return DerivedExecutionProfile.with(this, option, value);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withStringList(@NonNull DriverOption option, @NonNull List<String> value) {
        return DerivedExecutionProfile.with(this, option, value);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withStringMap(@NonNull DriverOption option, @NonNull Map<String, String> value) {
        return DerivedExecutionProfile.with(this, option, value);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withBytes(@NonNull DriverOption option, long value) {
        return DerivedExecutionProfile.with(this, option, value);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withBytesList(@NonNull DriverOption option, @NonNull List<Long> value) {
        return DerivedExecutionProfile.with(this, option, value);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withDuration(@NonNull DriverOption option, @NonNull Duration value) {
        return DerivedExecutionProfile.with(this, option, value);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile withDurationList(@NonNull DriverOption option, @NonNull List<Duration> value) {
        return DerivedExecutionProfile.with(this, option, value);
    }

    @Override
    @NonNull
    default public DriverExecutionProfile without(@NonNull DriverOption option) {
        return DerivedExecutionProfile.without(this, option);
    }
}

