/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.composite;

import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSortedSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiFunction;

public class CompositeDriverExecutionProfile
implements DriverExecutionProfile {
    private final DriverConfig primaryConfig;
    private final DriverConfig fallbackConfig;
    private final String profileName;
    @Nullable
    private volatile DriverExecutionProfile primaryProfile;
    @Nullable
    private volatile DriverExecutionProfile fallbackProfile;

    public CompositeDriverExecutionProfile(@NonNull DriverConfig primaryConfig, @NonNull DriverConfig fallbackConfig, @NonNull String profileName) {
        this.primaryConfig = Objects.requireNonNull(primaryConfig);
        this.fallbackConfig = Objects.requireNonNull(fallbackConfig);
        this.profileName = Objects.requireNonNull(profileName);
        this.refreshInternal();
    }

    public CompositeDriverExecutionProfile refresh() {
        return this.refreshInternal();
    }

    private CompositeDriverExecutionProfile refreshInternal() {
        try {
            this.primaryProfile = this.primaryConfig.getProfile(this.profileName);
        }
        catch (IllegalArgumentException e) {
            this.primaryProfile = null;
        }
        try {
            this.fallbackProfile = this.fallbackConfig.getProfile(this.profileName);
        }
        catch (IllegalArgumentException e) {
            this.fallbackProfile = null;
        }
        Preconditions.checkArgument(this.primaryProfile != null || this.fallbackProfile != null, "Unknown profile '%s'. Check your configuration.", (Object)this.profileName);
        return this;
    }

    @Override
    @NonNull
    public String getName() {
        return this.profileName;
    }

    @Override
    public boolean isDefined(@NonNull DriverOption option) {
        DriverExecutionProfile primaryProfile = this.primaryProfile;
        if (primaryProfile != null && primaryProfile.isDefined(option)) {
            return true;
        }
        DriverExecutionProfile fallbackProfile = this.fallbackProfile;
        return fallbackProfile != null && fallbackProfile.isDefined(option);
    }

    @Override
    public boolean getBoolean(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getBoolean);
    }

    @Override
    @NonNull
    public List<Boolean> getBooleanList(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getBooleanList);
    }

    @Override
    public int getInt(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getInt);
    }

    @Override
    @NonNull
    public List<Integer> getIntList(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getIntList);
    }

    @Override
    public long getLong(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getLong);
    }

    @Override
    @NonNull
    public List<Long> getLongList(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getLongList);
    }

    @Override
    public double getDouble(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getDouble);
    }

    @Override
    @NonNull
    public List<Double> getDoubleList(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getDoubleList);
    }

    @Override
    @NonNull
    public String getString(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getString);
    }

    @Override
    @NonNull
    public List<String> getStringList(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getStringList);
    }

    @Override
    @NonNull
    public Map<String, String> getStringMap(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getStringMap);
    }

    @Override
    public long getBytes(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getBytes);
    }

    @Override
    @NonNull
    public List<Long> getBytesList(DriverOption option) {
        return this.get(option, DriverExecutionProfile::getBytesList);
    }

    @Override
    @NonNull
    public Duration getDuration(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getDuration);
    }

    @Override
    @NonNull
    public List<Duration> getDurationList(@NonNull DriverOption option) {
        return this.get(option, DriverExecutionProfile::getDurationList);
    }

    private <ValueT> ValueT get(@NonNull DriverOption option, BiFunction<DriverExecutionProfile, DriverOption, ValueT> getter2) {
        DriverExecutionProfile primaryProfile = this.primaryProfile;
        if (primaryProfile != null && primaryProfile.isDefined(option)) {
            return getter2.apply(primaryProfile, option);
        }
        DriverExecutionProfile fallbackProfile = this.fallbackProfile;
        if (fallbackProfile != null && fallbackProfile.isDefined(option)) {
            return getter2.apply(fallbackProfile, option);
        }
        throw new IllegalArgumentException("Unknown option: " + option);
    }

    @Override
    @NonNull
    public SortedSet<Map.Entry<String, Object>> entrySet() {
        DriverExecutionProfile primaryProfile = this.primaryProfile;
        DriverExecutionProfile fallbackProfile = this.fallbackProfile;
        if (primaryProfile != null && fallbackProfile != null) {
            TreeSet result2 = new TreeSet(Map.Entry.comparingByKey());
            result2.addAll(fallbackProfile.entrySet());
            result2.addAll(primaryProfile.entrySet());
            return ImmutableSortedSet.copyOf(Map.Entry.comparingByKey(), result2);
        }
        if (primaryProfile != null) {
            return primaryProfile.entrySet();
        }
        assert (fallbackProfile != null);
        return fallbackProfile.entrySet();
    }
}

