/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.typesafe;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultDriverConfigLoader;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValueFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class DefaultProgrammaticDriverConfigLoaderBuilder
implements ProgrammaticDriverConfigLoaderBuilder {
    public static final Supplier<Config> DEFAULT_FALLBACK_SUPPLIER = () -> ConfigFactory.defaultApplication().withFallback(ConfigFactory.defaultReference(CqlSession.class.getClassLoader()));
    private final Map<String, Object> values = new HashMap<String, Object>();
    private final Supplier<Config> fallbackSupplier;
    private final String rootPath;
    private String currentProfileName = "default";

    public DefaultProgrammaticDriverConfigLoaderBuilder() {
        this(DEFAULT_FALLBACK_SUPPLIER, "datastax-java-driver");
    }

    public DefaultProgrammaticDriverConfigLoaderBuilder(@NonNull ClassLoader appClassLoader) {
        this(() -> ConfigFactory.defaultApplication(appClassLoader).withFallback(ConfigFactory.defaultReference(CqlSession.class.getClassLoader())), "datastax-java-driver");
    }

    public DefaultProgrammaticDriverConfigLoaderBuilder(@NonNull Supplier<Config> fallbackSupplier, @NonNull String rootPath) {
        this.fallbackSupplier = fallbackSupplier;
        this.rootPath = rootPath;
    }

    private ProgrammaticDriverConfigLoaderBuilder with(@NonNull DriverOption option, @Nullable Object value) {
        return this.with(option.getPath(), value);
    }

    private ProgrammaticDriverConfigLoaderBuilder with(@NonNull String path, @Nullable Object value) {
        if (!"default".equals(this.currentProfileName)) {
            path = "profiles." + this.currentProfileName + "." + path;
        }
        if (!this.rootPath.isEmpty()) {
            path = this.rootPath + "." + path;
        }
        this.values.put(path, value);
        return this;
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder startProfile(@NonNull String profileName) {
        this.currentProfileName = Objects.requireNonNull(profileName);
        return this;
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder endProfile() {
        this.currentProfileName = "default";
        return this;
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withBoolean(@NonNull DriverOption option, boolean value) {
        return this.with(option, (Object)value);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withBooleanList(@NonNull DriverOption option, @NonNull List<Boolean> value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withInt(@NonNull DriverOption option, int value) {
        return this.with(option, (Object)value);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withIntList(@NonNull DriverOption option, @NonNull List<Integer> value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withLong(@NonNull DriverOption option, long value) {
        return this.with(option, (Object)value);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withLongList(@NonNull DriverOption option, @NonNull List<Long> value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withDouble(@NonNull DriverOption option, double value) {
        return this.with(option, (Object)value);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withDoubleList(@NonNull DriverOption option, @NonNull List<Double> value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withString(@NonNull DriverOption option, @NonNull String value) {
        return this.with(option, (Object)value);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withStringList(@NonNull DriverOption option, @NonNull List<String> value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withStringMap(@NonNull DriverOption option, @NonNull Map<String, String> value) {
        for (String key : value.keySet()) {
            this.with(option.getPath() + "." + key, (Object)value.get(key));
        }
        return this;
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withBytes(@NonNull DriverOption option, long value) {
        return this.with(option, (Object)value);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withBytesList(@NonNull DriverOption option, @NonNull List<Long> value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withDuration(@NonNull DriverOption option, @NonNull Duration value) {
        return this.with(option, (Object)value);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder withDurationList(@NonNull DriverOption option, @NonNull List<Duration> value) {
        return this.with(option, value);
    }

    @Override
    @NonNull
    public ProgrammaticDriverConfigLoaderBuilder without(@NonNull DriverOption option) {
        return this.with(option, null);
    }

    @Override
    @NonNull
    public DriverConfigLoader build() {
        return new DefaultDriverConfigLoader(() -> {
            ConfigFactory.invalidateCaches();
            Config programmaticConfig = this.buildConfig();
            Config config = ConfigFactory.defaultOverrides().withFallback(programmaticConfig).withFallback(this.fallbackSupplier.get()).resolve();
            return this.rootPath.isEmpty() ? config : config.getConfig(this.rootPath);
        });
    }

    private Config buildConfig() {
        Config config = ConfigFactory.empty();
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            config = config.withValue(entry.getKey(), ConfigValueFactory.fromAnyRef(entry.getValue()));
        }
        return config;
    }
}

