/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import com.datastax.oss.driver.internal.core.metrics.DefaultMetricId;
import com.datastax.oss.driver.internal.core.metrics.MetricId;
import com.datastax.oss.driver.internal.core.metrics.MetricIdGenerator;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class DefaultMetricIdGenerator
implements MetricIdGenerator {
    private final String sessionPrefix;
    private final String nodePrefix;

    public DefaultMetricIdGenerator(DriverContext context) {
        String sessionName = context.getSessionName();
        String prefix = Objects.requireNonNull(context.getConfig().getDefaultProfile().getString(DefaultDriverOption.METRICS_ID_GENERATOR_PREFIX, ""));
        this.sessionPrefix = prefix.isEmpty() ? sessionName + '.' : prefix + '.' + sessionName + '.';
        this.nodePrefix = this.sessionPrefix + "nodes.";
    }

    @Override
    @NonNull
    public MetricId sessionMetricId(@NonNull SessionMetric metric) {
        return new DefaultMetricId(this.sessionPrefix + metric.getPath(), ImmutableMap.of());
    }

    @Override
    @NonNull
    public MetricId nodeMetricId(@NonNull Node node, @NonNull NodeMetric metric) {
        return new DefaultMetricId(this.nodePrefix + node.getEndPoint().asMetricPrefix() + '.' + metric.getPath(), ImmutableMap.of());
    }
}

