/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.session;

import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.session.RequestProcessor;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RequestProcessorRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(RequestProcessorRegistry.class);
    private final String logPrefix;
    private final RequestProcessor<?, ?>[] processors;

    public RequestProcessorRegistry(String logPrefix, RequestProcessor<?, ?> ... processors) {
        this.logPrefix = logPrefix;
        this.processors = processors;
    }

    public <RequestT extends Request, ResultT> RequestProcessor<RequestT, ResultT> processorFor(RequestT request, GenericType<ResultT> resultType) {
        for (RequestProcessor<ResultT, ResultT> requestProcessor : this.processors) {
            if (requestProcessor.canProcess(request, resultType)) {
                LOG.trace("[{}] Using {} to process {}", this.logPrefix, requestProcessor, request);
                RequestProcessor<ResultT, ResultT> result2 = requestProcessor;
                return result2;
            }
            LOG.trace("[{}] {} cannot process {}, trying next", this.logPrefix, requestProcessor, request);
        }
        throw new IllegalArgumentException("No request processor found for " + request);
    }

    public Iterable<RequestProcessor<?, ?>> getProcessors() {
        return ImmutableList.copyOf(this.processors);
    }
}

