/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.ProtocolErrors;
import com.datastax.oss.protocol.internal.response.result.DefaultRows;
import com.datastax.oss.protocol.internal.response.result.Prepared;
import com.datastax.oss.protocol.internal.response.result.SchemaChange;
import com.datastax.oss.protocol.internal.response.result.SetKeyspace;
import com.datastax.oss.protocol.internal.response.result.Void;
import com.datastax.oss.protocol.internal.util.IntMap;

public abstract class Result
extends Message {
    public final int kind;

    protected Result(int kind) {
        super(true, 8);
        this.kind = kind;
    }

    public static abstract class SubCodec {
        public final int kind;
        public final int protocolVersion;

        protected SubCodec(int kind, int protocolVersion) {
            this.kind = kind;
            this.protocolVersion = protocolVersion;
        }

        public abstract <B> void encode(B var1, Message var2, PrimitiveCodec<B> var3);

        public abstract int encodedSize(Message var1);

        public abstract <B> Message decode(B var1, PrimitiveCodec<B> var2);
    }

    public static class Codec
    extends Message.Codec {
        private final IntMap<SubCodec> subDecoders;

        public Codec(int protocolVersion, SubCodec ... subCodecs) {
            super(8, protocolVersion);
            IntMap.Builder<SubCodec> builder = IntMap.builder();
            for (SubCodec subCodec : subCodecs) {
                builder.put(subCodec.kind, subCodec);
            }
            this.subDecoders = builder.build();
        }

        public Codec(int protocolVersion) {
            this(protocolVersion, new Void.SubCodec(protocolVersion), new DefaultRows.SubCodec(protocolVersion), new SetKeyspace.SubCodec(protocolVersion), new Prepared.SubCodec(protocolVersion), new SchemaChange.SubCodec(protocolVersion));
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder) {
            Result result2 = (Result)message;
            encoder.writeInt(result2.kind, dest);
            this.getSubCodec(result2.kind).encode(dest, result2, encoder);
        }

        @Override
        public int encodedSize(Message message) {
            Result result2 = (Result)message;
            return 4 + this.getSubCodec(result2.kind).encodedSize(result2);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder) {
            int kind = decoder.readInt(source);
            return this.getSubCodec(kind).decode(source, decoder);
        }

        private SubCodec getSubCodec(int kind) {
            SubCodec subCodec = this.subDecoders.get(kind);
            ProtocolErrors.check(subCodec != null, "Unsupported result kind: %d", kind);
            return subCodec;
        }
    }
}

