/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.NoteInfo;
import org.apache.zeppelin.notebook.repo.NotebookRepoSettingsInfo;
import org.apache.zeppelin.notebook.repo.NotebookRepoWithVersionControl;
import org.apache.zeppelin.notebook.repo.RevisionsInfo;
import org.apache.zeppelin.notebook.repo.storage.OSSOperator;
import org.apache.zeppelin.notebook.repo.storage.RemoteStorageOperator;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSSNotebookRepo
implements NotebookRepoWithVersionControl {
    private static final Logger LOGGER = LoggerFactory.getLogger(OSSNotebookRepo.class);
    private String bucketName;
    private String rootFolder;
    private int maxVersionNumber;
    private RemoteStorageOperator ossOperator;

    public void init(ZeppelinConfiguration conf) throws IOException {
        String endpoint = conf.getOSSEndpoint();
        this.bucketName = conf.getOSSBucketName();
        this.rootFolder = conf.getNotebookDir();
        this.maxVersionNumber = conf.getOSSNoteMaxVersionNum();
        this.rootFolder = OSSNotebookRepo.formatPath(this.rootFolder);
        String accessKeyId = conf.getOSSAccessKeyId();
        String accessKeySecret = conf.getOSSAccessKeySecret();
        this.ossOperator = new OSSOperator(endpoint, accessKeyId, accessKeySecret);
    }

    private static String formatPath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((path = new File(path).getPath()).startsWith("./")) {
            path = path.substring(2);
        }
        return path;
    }

    public void setOssOperator(RemoteStorageOperator ossOperator) {
        this.ossOperator = ossOperator;
    }

    public Map<String, NoteInfo> list(AuthenticationInfo subject) throws IOException {
        HashMap<String, NoteInfo> notesInfo = new HashMap<String, NoteInfo>();
        List<String> objectKeys = this.ossOperator.listDirObjects(this.bucketName, this.rootFolder + "/");
        for (String key : objectKeys) {
            if (key.endsWith(".zpln")) {
                try {
                    String noteId = this.getNoteId(key);
                    String notePath = this.getNotePath(this.rootFolder, key);
                    notesInfo.put(noteId, new NoteInfo(noteId, notePath));
                }
                catch (IOException e) {
                    LOGGER.warn(e.getMessage());
                }
                continue;
            }
            LOGGER.debug("Skip invalid note file: {}", (Object)key);
        }
        return notesInfo;
    }

    public Note getByOSSPath(String noteId, String ossPath) throws IOException {
        String noteText = this.ossOperator.getTextObject(this.bucketName, ossPath);
        return Note.fromJson((String)noteId, (String)noteText);
    }

    public Note get(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
        return this.getByOSSPath(noteId, this.rootFolder + "/" + this.buildNoteFileName(noteId, notePath));
    }

    public void save(Note note, AuthenticationInfo subject) throws IOException {
        String content = note.toJson();
        this.ossOperator.putTextObject(this.bucketName, this.rootFolder + "/" + this.buildNoteFileName(note.getId(), note.getPath()), new ByteArrayInputStream(content.getBytes()));
    }

    public void move(String noteId, String notePath, String newNotePath, AuthenticationInfo subject) throws IOException {
        String noteSourceKey = this.rootFolder + "/" + this.buildNoteFileName(noteId, notePath);
        String noteDestKey = this.rootFolder + "/" + this.buildNoteFileName(noteId, newNotePath);
        this.ossOperator.moveObject(this.bucketName, noteSourceKey, noteDestKey);
        String revisionSourceDirKey = this.rootFolder + "/" + OSSNotebookRepo.buildRevisionsDirName(noteId, notePath);
        String revisionDestDirKey = this.rootFolder + "/" + OSSNotebookRepo.buildRevisionsDirName(noteId, newNotePath);
        this.ossOperator.moveDir(this.bucketName, revisionSourceDirKey, revisionDestDirKey);
    }

    public void move(String folderPath, String newFolderPath, AuthenticationInfo subject) {
        List<String> objectKeys = this.ossOperator.listDirObjects(this.bucketName, this.rootFolder + folderPath + "/");
        for (String key : objectKeys) {
            if (key.endsWith(".zpln")) {
                try {
                    String noteId = this.getNoteId(key);
                    String notePath = this.getNotePath(this.rootFolder, key);
                    String newNotePath = newFolderPath + notePath.substring(folderPath.length());
                    this.move(noteId, notePath, newNotePath, subject);
                }
                catch (IOException e) {
                    LOGGER.warn(e.getMessage());
                }
                continue;
            }
            LOGGER.debug("Skip invalid note file: {}", (Object)key);
        }
    }

    public void remove(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
        this.ossOperator.deleteFile(this.bucketName, this.rootFolder + "/" + this.buildNoteFileName(noteId, notePath));
        this.ossOperator.deleteDir(this.bucketName, this.rootFolder + "/" + OSSNotebookRepo.buildRevisionsDirName(noteId, notePath));
    }

    public void remove(String folderPath, AuthenticationInfo subject) throws IOException {
        List<String> objectKeys = this.ossOperator.listDirObjects(this.bucketName, this.rootFolder + folderPath + "/");
        for (String key : objectKeys) {
            if (!key.endsWith(".zpln")) continue;
            try {
                String noteId = this.getNoteId(key);
                String notePath = this.getNotePath(this.rootFolder, key);
                this.ossOperator.deleteDir(this.bucketName, this.rootFolder + "/" + OSSNotebookRepo.buildRevisionsDirName(noteId, notePath));
            }
            catch (IOException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        this.ossOperator.deleteFiles(this.bucketName, objectKeys);
    }

    public void close() {
        this.ossOperator.shutdown();
    }

    public List<NotebookRepoSettingsInfo> getSettings(AuthenticationInfo subject) {
        LOGGER.warn("Method not implemented");
        return Collections.emptyList();
    }

    public void updateSettings(Map<String, String> settings, AuthenticationInfo subject) {
        LOGGER.warn("Method not implemented");
    }

    private static String buildRevisionsDirName(String noteId, String notePath) throws IOException {
        if (!notePath.startsWith("/")) {
            throw new IOException("Invalid notePath: " + notePath);
        }
        return ".checkpoint/" + (notePath + "_" + noteId).substring(1);
    }

    private String buildRevisionsInfoAbsolutePath(String noteId, String notePath) throws IOException {
        return this.rootFolder + "/" + OSSNotebookRepo.buildRevisionsDirName(noteId, notePath) + "/.revision-info";
    }

    private String buildRevisionsFileAbsolutePath(String noteId, String notePath, String revisionId) throws IOException {
        return this.rootFolder + "/" + OSSNotebookRepo.buildRevisionsDirName(noteId, notePath) + "/" + revisionId;
    }

    public NotebookRepoWithVersionControl.Revision checkpoint(String noteId, String notePath, String checkpointMsg, AuthenticationInfo subject) throws IOException {
        String existedRevisionsInfoText;
        if (this.maxVersionNumber <= 0) {
            throw new IOException("Version control is closed because the value of zeppelin.notebook.oss.version.max is set to 0");
        }
        Note note = this.get(noteId, notePath, subject);
        String revisionId = UUID.randomUUID().toString().replace("-", "");
        String noteContent = note.toJson();
        this.ossOperator.putTextObject(this.bucketName, this.buildRevisionsFileAbsolutePath(noteId, notePath, revisionId), new ByteArrayInputStream(noteContent.getBytes()));
        NotebookRepoWithVersionControl.Revision revision = new NotebookRepoWithVersionControl.Revision(revisionId, checkpointMsg, (int)(System.currentTimeMillis() / 1000L));
        RevisionsInfo revisionsHistory = new RevisionsInfo();
        String revisonInfoPath = this.buildRevisionsInfoAbsolutePath(noteId, notePath);
        boolean found = this.ossOperator.doesObjectExist(this.bucketName, revisonInfoPath);
        if (found && (revisionsHistory = RevisionsInfo.fromText(existedRevisionsInfoText = this.ossOperator.getTextObject(this.bucketName, revisonInfoPath))).size() >= this.maxVersionNumber) {
            NotebookRepoWithVersionControl.Revision deletedRevision = (NotebookRepoWithVersionControl.Revision)revisionsHistory.removeLast();
            this.ossOperator.deleteFile(this.bucketName, this.buildRevisionsFileAbsolutePath(noteId, notePath, deletedRevision.id));
        }
        revisionsHistory.addFirst(revision);
        this.ossOperator.putTextObject(this.bucketName, this.buildRevisionsInfoAbsolutePath(noteId, notePath), new ByteArrayInputStream(revisionsHistory.toText().getBytes()));
        return revision;
    }

    public Note get(String noteId, String notePath, String revId, AuthenticationInfo subject) throws IOException {
        Note note = this.getByOSSPath(noteId, this.buildRevisionsFileAbsolutePath(noteId, notePath, revId));
        if (note != null) {
            note.setPath(notePath);
        }
        return note;
    }

    public List<NotebookRepoWithVersionControl.Revision> revisionHistory(String noteId, String notePath, AuthenticationInfo subject) throws IOException {
        if (this.maxVersionNumber <= 0) {
            return new ArrayList<NotebookRepoWithVersionControl.Revision>();
        }
        LinkedList<NotebookRepoWithVersionControl.Revision> revisions = new LinkedList<NotebookRepoWithVersionControl.Revision>();
        String revisonInfoPath = this.buildRevisionsInfoAbsolutePath(noteId, notePath);
        boolean found = this.ossOperator.doesObjectExist(this.bucketName, revisonInfoPath);
        if (!found) {
            return revisions;
        }
        String revisionsText = this.ossOperator.getTextObject(this.bucketName, revisonInfoPath);
        return RevisionsInfo.fromText(revisionsText);
    }

    public Note setNoteRevision(String noteId, String notePath, String revId, AuthenticationInfo subject) throws IOException {
        Note revisionNote = this.get(noteId, notePath, revId, subject);
        if (revisionNote != null) {
            this.save(revisionNote, subject);
        }
        return revisionNote;
    }
}

