/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.tag;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.util.LengthLimitingStringBuilder;
import com.hubspot.jinjava.util.ObjectTruthValue;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;

@JinjavaDoc(value="Outputs inner content if expression evaluates to true, otherwise evaluates any elif blocks, finally outputting content of any else block present", snippets={@JinjavaSnippet(code="{% if condition %}\nIf the condition is true print this to template.\n{% endif %}"), @JinjavaSnippet(code="{% if number <= 2 %}\nVariable named number is less than or equal to 2.\n{% elif number <= 4 %}\nVariable named number is less than or equal to 4.\n{% elif number <= 6 %}\nVariable named number is less than or equal to 6.\n{% else %}\nVariable named number is greater than 6.\n{% endif %}")})
public class IfTag
implements Tag {
    public static final String TAG_NAME = "if";
    private static final long serialVersionUID = -3784039314941268904L;

    @Override
    public boolean isRenderedInValidationMode() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String interpret(TagNode tagNode, JinjavaInterpreter interpreter) {
        if (StringUtils.isBlank((CharSequence)tagNode.getHelpers())) {
            throw new TemplateSyntaxException(tagNode.getMaster().getImage(), "Tag 'if' expects expression", tagNode.getLineNumber(), tagNode.getStartPosition());
        }
        LengthLimitingStringBuilder sb = new LengthLimitingStringBuilder(interpreter.getConfig().getMaxOutputSize());
        Iterator nodeIterator = tagNode.getChildren().iterator();
        boolean parentValidationMode = interpreter.getContext().isValidationMode();
        boolean execute = this.isPositiveIfElseNode(tagNode, interpreter);
        boolean executedAnyBlock = false;
        try {
            while (nodeIterator.hasNext()) {
                Node node;
                boolean bl = executedAnyBlock = executedAnyBlock || execute;
                if (interpreter.isValidationMode() && !parentValidationMode) {
                    interpreter.getContext().setValidationMode(!execute);
                }
                if (TagNode.class.isAssignableFrom((node = (Node)nodeIterator.next()).getClass())) {
                    TagNode tag = (TagNode)node;
                    if (tag.getName().equals("elif")) {
                        execute = !executedAnyBlock && this.isPositiveIfElseNode(tag, interpreter);
                        continue;
                    }
                    if (tag.getName().equals("else")) {
                        execute = !executedAnyBlock;
                        continue;
                    }
                }
                if (execute) {
                    sb.append(node.render(interpreter));
                    continue;
                }
                if (!interpreter.getContext().isValidationMode()) continue;
                node.render(interpreter);
            }
        }
        finally {
            interpreter.getContext().setValidationMode(parentValidationMode);
        }
        return sb.toString();
    }

    protected boolean isPositiveIfElseNode(TagNode tagNode, JinjavaInterpreter interpreter) {
        return ObjectTruthValue.evaluate(interpreter.resolveELExpression(tagNode.getHelpers(), tagNode.getLineNumber()));
    }

    @Override
    public String getName() {
        return TAG_NAME;
    }
}

