/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication.jaas;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityContextLoginModule
implements LoginModule {
    private static final Log log = LogFactory.getLog(SecurityContextLoginModule.class);
    private Authentication authen;
    private Subject subject;
    private boolean ignoreMissingAuthentication = false;

    public boolean abort() throws LoginException {
        if (this.authen == null) {
            return false;
        }
        this.authen = null;
        return true;
    }

    public boolean commit() throws LoginException {
        if (this.authen == null) {
            return false;
        }
        this.subject.getPrincipals().add(this.authen);
        return true;
    }

    Authentication getAuthentication() {
        return this.authen;
    }

    Subject getSubject() {
        return this.subject;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        if (options != null) {
            this.ignoreMissingAuthentication = "true".equals(options.get("ignoreMissingAuthentication"));
        }
    }

    public boolean login() throws LoginException {
        this.authen = SecurityContextHolder.getContext().getAuthentication();
        if (this.authen == null) {
            String msg = "Login cannot complete, authentication not found in security context";
            if (this.ignoreMissingAuthentication) {
                log.warn(msg);
                return false;
            }
            throw new LoginException(msg);
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.authen == null) {
            return false;
        }
        this.subject.getPrincipals().remove(this.authen);
        this.authen = null;
        return true;
    }
}

