/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.util;

import com.google.common.base.MoreObjects;
import com.pty4j.util.PtyUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExtractedNative {
    private static final Logger LOG = Logger.getLogger(ExtractedNative.class);
    static final String[] LOCATIONS = new String[]{"freebsd/x86/libpty.so", "freebsd/x86_64/libpty.so", "linux/x86/libpty.so", "linux/x86_64/libpty.so", "linux/ppc64le/libpty.so", "macosx/x86/libpty.dylib", "macosx/x86_64/libpty.dylib", "win/x86/winpty-agent.exe", "win/x86/winpty.dll", "win/x86_64/cyglaunch.exe", "win/x86_64/winpty-agent.exe", "win/x86_64/winpty.dll", "win/xp/winpty-agent.exe", "win/xp/winpty.dll"};
    static final String DEFAULT_RESOURCE_NAME_PREFIX = "resources/com/pty4j/native/";
    private static final ExtractedNative INSTANCE = new ExtractedNative();
    private String myPlatformFolderName;
    private String myArchFolderName;
    private String myResourceNamePrefix;
    private boolean myInitialized;
    private volatile File myDestDir;

    private ExtractedNative() {
        this(null, null, null);
    }

    ExtractedNative(@Nullable String platformFolderName, @Nullable String archFolderName, @Nullable String resourceNamePrefix) {
        this.myPlatformFolderName = platformFolderName;
        this.myArchFolderName = archFolderName;
        this.myResourceNamePrefix = resourceNamePrefix;
    }

    @NotNull
    public static ExtractedNative getInstance() {
        return INSTANCE;
    }

    @NotNull
    File getDestDir() {
        if (!this.myInitialized) {
            this.init();
        }
        return this.myDestDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        try {
            this.myPlatformFolderName = MoreObjects.firstNonNull(this.myPlatformFolderName, PtyUtil.getPlatformFolderName());
            this.myArchFolderName = MoreObjects.firstNonNull(this.myArchFolderName, PtyUtil.getPlatformArchFolderName());
            this.myResourceNamePrefix = MoreObjects.firstNonNull(this.myResourceNamePrefix, DEFAULT_RESOURCE_NAME_PREFIX);
            ExtractedNative extractedNative = this;
            synchronized (extractedNative) {
                if (!this.myInitialized) {
                    this.doInit();
                }
                this.myInitialized = true;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot extract pty4j native " + this.myPlatformFolderName + "/" + this.myArchFolderName, e);
        }
    }

    private void doInit() throws IOException {
        long startTimeNano = System.nanoTime();
        Path destDir = this.getOrCreateDestDir();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found " + destDir.toString() + " in " + ExtractedNative.pastTime(startTimeNano));
        }
        List children = Files.list(destDir).collect(Collectors.toList());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Listed files in " + ExtractedNative.pastTime(startTimeNano));
        }
        HashMap<String, Path> resourceToFileMap = new HashMap<String, Path>();
        for (Path child : children) {
            String resourceName = this.getResourceName(child.getFileName().toString());
            resourceToFileMap.put(resourceName, child);
        }
        Set<String> bundledResourceNames = this.getBundledResourceNames();
        boolean upToDate = this.isUpToDate(bundledResourceNames, resourceToFileMap);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checked upToDate in " + ExtractedNative.pastTime(startTimeNano));
        }
        if (!upToDate) {
            for (Path child : children) {
                Files.delete(child);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cleared directory in " + ExtractedNative.pastTime(startTimeNano));
            }
            for (String bundledResourceName : bundledResourceNames) {
                this.copy(bundledResourceName, destDir);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Copied " + bundledResourceNames + " in " + ExtractedNative.pastTime(startTimeNano));
            }
        }
        this.myDestDir = destDir.toFile();
        LOG.info("Extracted pty4j native in " + ExtractedNative.pastTime(startTimeNano));
    }

    @NotNull
    private Path getOrCreateDestDir() throws IOException {
        Path staticParentDir;
        String staticParentDirPath = System.getProperty("pty4j.tmpdir");
        String prefix = "pty4j-" + this.myPlatformFolderName + "-" + this.myArchFolderName;
        if (staticParentDirPath != null && !staticParentDirPath.trim().isEmpty() && (staticParentDir = Paths.get(staticParentDirPath, new String[0])).isAbsolute()) {
            Path staticDir = staticParentDir.resolve(prefix);
            if (Files.isDirectory(staticDir, new LinkOption[0])) {
                return staticDir;
            }
            if (Files.isDirectory(staticParentDir, new LinkOption[0])) {
                if (Files.exists(staticDir, new LinkOption[0])) {
                    Files.delete(staticDir);
                }
                return Files.createDirectory(staticDir, new FileAttribute[0]);
            }
        }
        Path tempDirectory = Files.createTempDirectory(prefix + "-", new FileAttribute[0]);
        tempDirectory.toFile().deleteOnExit();
        return tempDirectory;
    }

    private boolean isUpToDate(@NotNull Set<String> bundledResourceNames, @NotNull Map<String, Path> resourceToFileMap) {
        if (!bundledResourceNames.equals(resourceToFileMap.keySet())) {
            return false;
        }
        for (Map.Entry<String, Path> entry : resourceToFileMap.entrySet()) {
            try {
                byte[] fileContentChecksum;
                URL bundledUrl = this.getBundledResourceUrl(entry.getKey());
                byte[] bundledContentChecksum = ExtractedNative.md5(bundledUrl.openStream());
                if (Arrays.equals(bundledContentChecksum, fileContentChecksum = ExtractedNative.md5(Files.newInputStream(entry.getValue(), new OpenOption[0])))) continue;
                return false;
            }
            catch (Exception e) {
                LOG.error("Cannot compare md5 checksums", e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static byte[] md5(@NotNull InputStream in) throws IOException, NoSuchAlgorithmException {
        try {
            int bufferSize;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            while ((bufferSize = in.read(buffer)) >= 0) {
                md5.update(buffer, 0, bufferSize);
            }
            byte[] byArray = md5.digest();
            return byArray;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                LOG.error("Cannot close", e);
            }
        }
    }

    @NotNull
    private Set<String> getBundledResourceNames() {
        HashSet<String> resourceNames = new HashSet<String>();
        String prefix = this.myPlatformFolderName + "/" + this.myArchFolderName + "/";
        for (String location : LOCATIONS) {
            if (!location.startsWith(prefix)) continue;
            resourceNames.add(this.myResourceNamePrefix + location);
        }
        return resourceNames;
    }

    @NotNull
    private String getResourceName(@NotNull String fileName) {
        return this.myResourceNamePrefix + this.myPlatformFolderName + "/" + this.myArchFolderName + "/" + fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(@NotNull String resourceName, @NotNull Path destDir) throws IOException {
        URL url = this.getBundledResourceUrl(resourceName);
        int lastNameInd = resourceName.lastIndexOf(47);
        String name = lastNameInd != -1 ? resourceName.substring(lastNameInd + 1) : resourceName;
        InputStream inputStream = url.openStream();
        try {
            Files.copy(inputStream, destDir.resolve(name), new CopyOption[0]);
        }
        finally {
            inputStream.close();
        }
    }

    @NotNull
    private URL getBundledResourceUrl(@NotNull String resourceName) throws IOException {
        ClassLoader classLoader = ExtractedNative.class.getClassLoader();
        URL url = classLoader.getResource(resourceName);
        if (url == null) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                url = contextClassLoader.getResource(resourceName);
            }
            if (url == null) {
                throw new IOException("Unable to load " + resourceName);
            }
        }
        return url;
    }

    @NotNull
    private static String pastTime(long startTimeNano) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNano) + " ms";
    }
}

