/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jupyter.io.grpc;

import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class Deadline
implements Comparable<Deadline> {
    private static final SystemTicker SYSTEM_TICKER = new SystemTicker();
    private static final long MAX_OFFSET = TimeUnit.DAYS.toNanos(36500L);
    private static final long MIN_OFFSET = -MAX_OFFSET;
    private static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private final Ticker ticker;
    private final long deadlineNanos;
    private volatile boolean expired;

    public static Ticker getSystemTicker() {
        return SYSTEM_TICKER;
    }

    public static Deadline after(long duration, TimeUnit units) {
        return Deadline.after(duration, units, SYSTEM_TICKER);
    }

    public static Deadline after(long duration, TimeUnit units, Ticker ticker) {
        Deadline.checkNotNull(units, "units");
        return new Deadline(ticker, units.toNanos(duration), true);
    }

    private Deadline(Ticker ticker, long offset, boolean baseInstantAlreadyExpired) {
        this(ticker, ticker.nanoTime(), offset, baseInstantAlreadyExpired);
    }

    private Deadline(Ticker ticker, long baseInstant, long offset, boolean baseInstantAlreadyExpired) {
        this.ticker = ticker;
        offset = Math.min(MAX_OFFSET, Math.max(MIN_OFFSET, offset));
        this.deadlineNanos = baseInstant + offset;
        this.expired = baseInstantAlreadyExpired && offset <= 0L;
    }

    public boolean isExpired() {
        if (!this.expired) {
            if (this.deadlineNanos - this.ticker.nanoTime() <= 0L) {
                this.expired = true;
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean isBefore(Deadline other) {
        this.checkTicker(other);
        return this.deadlineNanos - other.deadlineNanos < 0L;
    }

    public Deadline minimum(Deadline other) {
        this.checkTicker(other);
        return this.isBefore(other) ? this : other;
    }

    public Deadline offset(long offset, TimeUnit units) {
        if (offset == 0L) {
            return this;
        }
        return new Deadline(this.ticker, this.deadlineNanos, units.toNanos(offset), this.isExpired());
    }

    public long timeRemaining(TimeUnit unit) {
        long nowNanos = this.ticker.nanoTime();
        if (!this.expired && this.deadlineNanos - nowNanos <= 0L) {
            this.expired = true;
        }
        return unit.convert(this.deadlineNanos - nowNanos, TimeUnit.NANOSECONDS);
    }

    public ScheduledFuture<?> runOnExpiration(Runnable task, ScheduledExecutorService scheduler) {
        Deadline.checkNotNull(task, "task");
        Deadline.checkNotNull(scheduler, "scheduler");
        return scheduler.schedule(task, this.deadlineNanos - this.ticker.nanoTime(), TimeUnit.NANOSECONDS);
    }

    public String toString() {
        long remainingNanos = this.timeRemaining(TimeUnit.NANOSECONDS);
        long seconds = Math.abs(remainingNanos) / NANOS_PER_SECOND;
        long nanos = Math.abs(remainingNanos) % NANOS_PER_SECOND;
        StringBuilder buf = new StringBuilder();
        if (remainingNanos < 0L) {
            buf.append('-');
        }
        buf.append(seconds);
        if (nanos > 0L) {
            buf.append(String.format(Locale.US, ".%09d", nanos));
        }
        buf.append("s from now");
        if (this.ticker != SYSTEM_TICKER) {
            buf.append(" (ticker=" + this.ticker + ")");
        }
        return buf.toString();
    }

    @Override
    public int compareTo(Deadline that) {
        this.checkTicker(that);
        long diff = this.deadlineNanos - that.deadlineNanos;
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return Arrays.asList(this.ticker, this.deadlineNanos).hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Deadline)) {
            return false;
        }
        Deadline other = (Deadline)o;
        if (this.ticker == null ? other.ticker != null : this.ticker != other.ticker) {
            return false;
        }
        return this.deadlineNanos == other.deadlineNanos;
    }

    private static <T> T checkNotNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    private void checkTicker(Deadline other) {
        if (this.ticker != other.ticker) {
            throw new AssertionError((Object)("Tickers (" + this.ticker + " and " + other.ticker + ") don't match. Custom Ticker should only be used in tests!"));
        }
    }

    private static class SystemTicker
    extends Ticker {
        private SystemTicker() {
        }

        @Override
        public long nanoTime() {
            return System.nanoTime();
        }
    }

    public static abstract class Ticker {
        public abstract long nanoTime();
    }
}

