/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.decoders;

import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import org.eclipse.jetty.websocket.jsr356.decoders.AbstractDecoder;

public class DoubleDecoder
extends AbstractDecoder
implements Decoder.Text<Double> {
    public static final DoubleDecoder INSTANCE = new DoubleDecoder();

    @Override
    public Double decode(String s2) throws DecodeException {
        try {
            return Double.parseDouble(s2);
        }
        catch (NumberFormatException e) {
            throw new DecodeException(s2, "Unable to parse double", (Throwable)e);
        }
    }

    @Override
    public boolean willDecode(String s2) {
        if (s2 == null) {
            return false;
        }
        try {
            Double.parseDouble(s2);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

