/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.decoders;

import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import org.eclipse.jetty.websocket.jsr356.decoders.AbstractDecoder;

public class IntegerDecoder
extends AbstractDecoder
implements Decoder.Text<Integer> {
    public static final IntegerDecoder INSTANCE = new IntegerDecoder();

    @Override
    public Integer decode(String s2) throws DecodeException {
        try {
            return Integer.parseInt(s2);
        }
        catch (NumberFormatException e) {
            throw new DecodeException(s2, "Unable to parse Integer", (Throwable)e);
        }
    }

    @Override
    public boolean willDecode(String s2) {
        if (s2 == null) {
            return false;
        }
        try {
            Integer.parseInt(s2);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

