/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.decoders;

import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import org.eclipse.jetty.websocket.jsr356.decoders.AbstractDecoder;

public class LongDecoder
extends AbstractDecoder
implements Decoder.Text<Long> {
    public static final LongDecoder INSTANCE = new LongDecoder();

    @Override
    public Long decode(String s2) throws DecodeException {
        try {
            return Long.parseLong(s2);
        }
        catch (NumberFormatException e) {
            throw new DecodeException(s2, "Unable to parse Long", (Throwable)e);
        }
    }

    @Override
    public boolean willDecode(String s2) {
        if (s2 == null) {
            return false;
        }
        try {
            Long.parseLong(s2);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

