/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.extend.FSImage;
import com.openhtmltopdf.extend.FSObjectDrawer;
import com.openhtmltopdf.extend.FSObjectDrawerFactory;
import com.openhtmltopdf.extend.ReplacedElement;
import com.openhtmltopdf.extend.ReplacedElementFactory;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.pdfboxout.BookmarkElement;
import com.openhtmltopdf.pdfboxout.PdfBoxImageElement;
import com.openhtmltopdf.pdfboxout.PdfBoxObjectDrawerReplacedElement;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxPDFReplacedElement;
import com.openhtmltopdf.pdfboxout.PdfBoxSVGReplacedElement;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.resource.XMLResource;
import org.w3c.dom.Element;

public class PdfBoxReplacedElementFactory
implements ReplacedElementFactory {
    private final SVGDrawer _svgImpl;
    private final SVGDrawer _mathmlImpl;
    private final FSObjectDrawerFactory _objectDrawerFactory;
    private final PdfBoxOutputDevice _outputDevice;

    public PdfBoxReplacedElementFactory(PdfBoxOutputDevice outputDevice, SVGDrawer svgImpl, FSObjectDrawerFactory objectDrawerFactory, SVGDrawer mathmlImpl) {
        this._outputDevice = outputDevice;
        this._svgImpl = svgImpl;
        this._objectDrawerFactory = objectDrawerFactory;
        this._mathmlImpl = mathmlImpl;
    }

    @Override
    public ReplacedElement createReplacedElement(LayoutContext c, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        Element e = box.getElement();
        if (e == null) {
            return null;
        }
        String nodeName = e.getNodeName();
        if (nodeName.equals("math") && this._mathmlImpl != null) {
            return new PdfBoxSVGReplacedElement(e, this._mathmlImpl, cssWidth, cssHeight, box, c, c.getSharedContext());
        }
        if (nodeName.equals("svg") && this._svgImpl != null) {
            return new PdfBoxSVGReplacedElement(e, this._svgImpl, cssWidth, cssHeight, box, c, c.getSharedContext());
        }
        if (nodeName.equals("img")) {
            String srcAttr = e.getAttribute("src");
            if (srcAttr != null && srcAttr.length() > 0) {
                if (srcAttr.endsWith(".svg") && this._svgImpl != null) {
                    XMLResource xml = uac.getXMLResource(srcAttr);
                    if (xml != null) {
                        return new PdfBoxSVGReplacedElement(xml.getDocument().getDocumentElement(), this._svgImpl, cssWidth, cssHeight, box, c, c.getSharedContext());
                    }
                    return null;
                }
                if (srcAttr.endsWith(".pdf")) {
                    byte[] pdfBytes = uac.getBinaryResource(srcAttr);
                    if (pdfBytes != null) {
                        return PdfBoxPDFReplacedElement.create(this._outputDevice.getWriter(), pdfBytes, e, box, c, c.getSharedContext());
                    }
                    return null;
                }
                FSImage fsImage = uac.getImageResource(srcAttr).getImage();
                if (fsImage != null) {
                    return new PdfBoxImageElement(e, fsImage, c.getSharedContext(), box.getStyle().isImageRenderingInterpolate());
                }
            }
        } else if (!nodeName.equals("input")) {
            FSObjectDrawer drawer;
            if (nodeName.equals("bookmark")) {
                BookmarkElement result = new BookmarkElement();
                if (e.hasAttribute("name")) {
                    String name = e.getAttribute("name");
                    c.addBoxId(name, box);
                    result.setAnchorName(name);
                }
                return result;
            }
            if (nodeName.equals("object") && this._objectDrawerFactory != null && (drawer = this._objectDrawerFactory.createDrawer(e)) != null) {
                return new PdfBoxObjectDrawerReplacedElement(e, drawer, cssWidth, cssHeight, c.getSharedContext());
            }
        }
        return null;
    }

    @Override
    public boolean isReplacedElement(Element e) {
        if (e == null) {
            return false;
        }
        String nodeName = e.getNodeName();
        if (nodeName.equals("img")) {
            return true;
        }
        if (nodeName.equals("math") && this._mathmlImpl != null) {
            return true;
        }
        if (nodeName.equals("svg") && this._svgImpl != null) {
            return true;
        }
        if (nodeName.equals("bookmark")) {
            return true;
        }
        if (nodeName.equals("object") && this._objectDrawerFactory != null) {
            return this._objectDrawerFactory.isReplacedObject(e);
        }
        return false;
    }
}

