/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.el;

import com.google.common.collect.ImmutableMap;
import com.hubspot.jinjava.el.JinjavaELContext;
import com.hubspot.jinjava.el.JinjavaInterpreterResolver;
import com.hubspot.jinjava.el.ext.NamedParameter;
import com.hubspot.jinjava.interpret.DeferredValueException;
import com.hubspot.jinjava.interpret.DisabledException;
import com.hubspot.jinjava.interpret.InterpretException;
import com.hubspot.jinjava.interpret.InvalidArgumentException;
import com.hubspot.jinjava.interpret.InvalidInputException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.LazyExpression;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.interpret.UnknownTokenException;
import com.hubspot.jinjava.interpret.errorcategory.BasicTemplateErrorCategory;
import com.hubspot.jinjava.lib.fn.ELFunctionDefinition;
import java.util.List;
import java.util.Map;
import jinjava.de.odysseus.el.tree.TreeBuilderException;
import jinjava.javax.el.ELException;
import jinjava.javax.el.ExpressionFactory;
import jinjava.javax.el.PropertyNotFoundException;
import jinjava.javax.el.ValueExpression;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ExpressionResolver {
    private final JinjavaInterpreter interpreter;
    private final ExpressionFactory expressionFactory;
    private final JinjavaInterpreterResolver resolver;
    private final JinjavaELContext elContext;
    private static final String EXPRESSION_START_TOKEN = "#{";
    private static final String EXPRESSION_END_TOKEN = "}";

    public ExpressionResolver(JinjavaInterpreter interpreter, ExpressionFactory expressionFactory) {
        this.interpreter = interpreter;
        this.expressionFactory = expressionFactory;
        this.resolver = new JinjavaInterpreterResolver(interpreter);
        this.elContext = new JinjavaELContext(this.resolver);
        for (ELFunctionDefinition fn : interpreter.getContext().getAllFunctions()) {
            this.elContext.setFunction(fn.getNamespace(), fn.getLocalName(), fn.getMethod());
        }
    }

    public Object resolveExpression(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return null;
        }
        this.interpreter.getContext().addResolvedExpression(expression.trim());
        try {
            String elExpression = EXPRESSION_START_TOKEN + expression.trim() + EXPRESSION_END_TOKEN;
            ValueExpression valueExp = this.expressionFactory.createValueExpression(this.elContext, elExpression, Object.class);
            Object result = valueExp.getValue(this.elContext);
            if (result == null && this.interpreter.getConfig().isFailOnUnknownTokens()) {
                throw new UnknownTokenException(expression, this.interpreter.getLineNumber(), this.interpreter.getPosition());
            }
            if (result instanceof LazyExpression) {
                result = ((LazyExpression)result).get();
            }
            this.validateResult(result);
            return result;
        }
        catch (PropertyNotFoundException e) {
            this.interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.UNKNOWN, TemplateError.ErrorItem.PROPERTY, e.getMessage(), "", this.interpreter.getLineNumber(), this.interpreter.getPosition(), e, BasicTemplateErrorCategory.UNKNOWN, (Map<String, String>)ImmutableMap.of((Object)"exception", (Object)e.getMessage())));
        }
        catch (TreeBuilderException e) {
            int position = this.interpreter.getPosition() + e.getPosition();
            String errorMessage = StringUtils.substringAfter((String)e.getMessage(), (String)"': ").replaceFirst("position [0-9]+", "position " + position);
            this.interpreter.addError(TemplateError.fromException(new TemplateSyntaxException(expression.substring(e.getPosition() - EXPRESSION_START_TOKEN.length()), "Error parsing '" + expression + "': " + errorMessage, this.interpreter.getLineNumber(), position, e)));
        }
        catch (ELException e) {
            if (e.getCause() != null && e.getCause() instanceof DeferredValueException) {
                throw (DeferredValueException)e.getCause();
            }
            if (e.getCause() != null && e.getCause() instanceof TemplateSyntaxException) {
                this.interpreter.addError(TemplateError.fromException((TemplateSyntaxException)e.getCause()));
            } else if (e.getCause() != null && e.getCause() instanceof InvalidInputException) {
                this.interpreter.addError(TemplateError.fromInvalidInputException((InvalidInputException)e.getCause()));
            } else if (e.getCause() != null && e.getCause() instanceof InvalidArgumentException) {
                this.interpreter.addError(TemplateError.fromInvalidArgumentException((InvalidArgumentException)e.getCause()));
            } else {
                this.interpreter.addError(TemplateError.fromException(new TemplateSyntaxException(expression, e.getMessage(), this.interpreter.getLineNumber(), e)));
            }
        }
        catch (DisabledException e) {
            this.interpreter.addError(new TemplateError(TemplateError.ErrorType.FATAL, TemplateError.ErrorReason.DISABLED, TemplateError.ErrorItem.FUNCTION, e.getMessage(), expression, this.interpreter.getLineNumber(), this.interpreter.getPosition(), e));
        }
        catch (UnknownTokenException e) {
            throw e;
        }
        catch (DeferredValueException e) {
            throw e;
        }
        catch (InvalidInputException e) {
            this.interpreter.addError(TemplateError.fromInvalidInputException(e));
        }
        catch (InvalidArgumentException e) {
            this.interpreter.addError(TemplateError.fromInvalidArgumentException(e));
        }
        catch (Exception e) {
            this.interpreter.addError(TemplateError.fromException(new InterpretException(String.format("Error resolving expression [%s]: " + ExceptionUtils.getRootCauseMessage((Throwable)e), expression), (Throwable)e, this.interpreter.getLineNumber(), this.interpreter.getPosition())));
        }
        return null;
    }

    private void validateResult(Object result) {
        if (result instanceof NamedParameter) {
            throw new ELException("Unexpected '=' operator (use {% set %} tag for variable assignment)");
        }
    }

    public Object resolveProperty(Object object, List<String> propertyNames) {
        Object value = this.resolver.wrap(object);
        for (String propertyName : propertyNames) {
            if (value == null) {
                return null;
            }
            value = this.resolver.getValue(this.elContext, value, propertyName);
        }
        return value;
    }

    public Object wrap(Object object) {
        return this.resolver.wrap(object);
    }
}

