/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.tree;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.hubspot.jinjava.interpret.DisabledException;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.MissingEndTagException;
import com.hubspot.jinjava.interpret.TemplateError;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.interpret.UnexpectedTokenException;
import com.hubspot.jinjava.interpret.UnknownTagException;
import com.hubspot.jinjava.lib.tag.EndTag;
import com.hubspot.jinjava.lib.tag.Tag;
import com.hubspot.jinjava.tree.ExpressionNode;
import com.hubspot.jinjava.tree.Node;
import com.hubspot.jinjava.tree.RootNode;
import com.hubspot.jinjava.tree.TagNode;
import com.hubspot.jinjava.tree.TextNode;
import com.hubspot.jinjava.tree.parse.ExpressionToken;
import com.hubspot.jinjava.tree.parse.TagToken;
import com.hubspot.jinjava.tree.parse.TextToken;
import com.hubspot.jinjava.tree.parse.Token;
import com.hubspot.jinjava.tree.parse.TokenScanner;
import com.hubspot.jinjava.tree.parse.TokenScannerSymbols;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;

public class TreeParser {
    private final PeekingIterator<Token> scanner;
    private final JinjavaInterpreter interpreter;
    private final TokenScannerSymbols symbols;
    private Node parent;

    public TreeParser(JinjavaInterpreter interpreter, String input) {
        this.scanner = Iterators.peekingIterator((Iterator)((Object)new TokenScanner(input, interpreter.getConfig())));
        this.interpreter = interpreter;
        this.symbols = interpreter.getConfig().getTokenScannerSymbols();
    }

    public Node buildTree() {
        RootNode root = new RootNode(this.symbols);
        this.parent = root;
        while (this.scanner.hasNext()) {
            Node node = this.nextNode();
            if (node == null) continue;
            this.parent.getChildren().add(node);
        }
        do {
            if (this.parent == root) continue;
            this.interpreter.addError(TemplateError.fromException(new MissingEndTagException(((TagNode)this.parent).getEndName(), this.parent.getMaster().getImage(), this.parent.getLineNumber(), this.parent.getStartPosition())));
            this.parent = this.parent.getParent();
        } while (this.parent.getParent() != null);
        return root;
    }

    private Node nextNode() {
        Token token = (Token)this.scanner.next();
        if (token.getType() == this.symbols.getFixed()) {
            return this.text((TextToken)token);
        }
        if (token.getType() == this.symbols.getExprStart()) {
            return this.expression((ExpressionToken)token);
        }
        if (token.getType() == this.symbols.getTag()) {
            return this.tag((TagToken)token);
        }
        if (token.getType() == this.symbols.getNote()) {
            String commentClosed = this.symbols.getClosingComment();
            if (!token.getImage().endsWith(commentClosed)) {
                this.interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.SYNTAX_ERROR, TemplateError.ErrorItem.TAG, "Unclosed comment", "comment", token.getLineNumber(), token.getStartPosition(), null));
            }
        } else {
            this.interpreter.addError(TemplateError.fromException(new UnexpectedTokenException(token.getImage(), token.getLineNumber(), token.getStartPosition())));
        }
        return null;
    }

    private Node getLastSibling() {
        if (this.parent == null || this.parent.getChildren().isEmpty()) {
            return null;
        }
        return this.parent.getChildren().getLast();
    }

    private Node text(TextToken textToken) {
        Node lastSibling;
        if (this.interpreter.getConfig().isLstripBlocks() && this.scanner.hasNext() && ((Token)this.scanner.peek()).getType() == this.symbols.getTag()) {
            textToken = new TextToken(StringUtils.stripEnd((String)textToken.getImage(), (String)"\t "), textToken.getLineNumber(), textToken.getStartPosition(), this.symbols);
        }
        if ((lastSibling = this.getLastSibling()) instanceof TagNode && lastSibling.getMaster().isRightTrimAfterEnd()) {
            textToken.setLeftTrim(true);
        }
        if (this.parent instanceof TagNode && lastSibling == null && this.parent.getMaster().isRightTrim()) {
            textToken.setLeftTrim(true);
        }
        TextNode n = new TextNode(textToken);
        n.setParent(this.parent);
        return n;
    }

    private Node expression(ExpressionToken expressionToken) {
        ExpressionNode n = new ExpressionNode(expressionToken);
        n.setParent(this.parent);
        return n;
    }

    private Node tag(TagToken tagToken) {
        Node lastSibling;
        Tag tag;
        try {
            tag = this.interpreter.getContext().getTag(tagToken.getTagName());
            if (tag == null) {
                this.interpreter.addError(TemplateError.fromException(new UnknownTagException(tagToken)));
                return null;
            }
        }
        catch (DisabledException e) {
            this.interpreter.addError(new TemplateError(TemplateError.ErrorType.FATAL, TemplateError.ErrorReason.DISABLED, TemplateError.ErrorItem.TAG, e.getMessage(), tagToken.getTagName(), this.interpreter.getLineNumber(), tagToken.getStartPosition(), e));
            return null;
        }
        if (tag instanceof EndTag) {
            this.endTag(tag, tagToken);
            return null;
        }
        if (tagToken.isLeftTrim() && (lastSibling = this.getLastSibling()) instanceof TextNode) {
            lastSibling.getMaster().setRightTrim(true);
        }
        TagNode node = new TagNode(tag, tagToken, this.symbols);
        node.setParent(this.parent);
        if (node.getEndName() != null) {
            this.parent.getChildren().add(node);
            this.parent = node;
            return null;
        }
        return node;
    }

    private void endTag(Tag tag, TagToken tagToken) {
        Node lastSibling = this.getLastSibling();
        if (this.parent instanceof TagNode && tagToken.isLeftTrim() && lastSibling instanceof TextNode) {
            lastSibling.getMaster().setRightTrim(true);
        }
        if (this.parent.getMaster() != null) {
            this.parent.getMaster().setRightTrimAfterEnd(tagToken.isRightTrim());
        }
        boolean hasMatchingStartTag = false;
        while (!(this.parent instanceof RootNode)) {
            TagNode parentTag = (TagNode)this.parent;
            this.parent = this.parent.getParent();
            if (parentTag.getEndName().equals(tag.getEndTagName())) {
                hasMatchingStartTag = true;
                break;
            }
            this.interpreter.addError(TemplateError.fromException(new TemplateSyntaxException(tagToken.getImage(), "Mismatched end tag, expected: " + parentTag.getEndName(), tagToken.getLineNumber(), tagToken.getStartPosition())));
        }
        if (!hasMatchingStartTag) {
            this.interpreter.addError(new TemplateError(TemplateError.ErrorType.WARNING, TemplateError.ErrorReason.SYNTAX_ERROR, TemplateError.ErrorItem.TAG, "Missing start tag", tag.getName(), tagToken.getLineNumber(), tagToken.getStartPosition(), null));
        }
    }
}

