/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.counter.impl;

import io.atomix.core.counter.AsyncAtomicCounter;
import io.atomix.core.counter.AtomicCounter;
import io.atomix.primitive.AsyncPrimitive;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.Synchronous;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BlockingAtomicCounter
extends Synchronous<AsyncAtomicCounter>
implements AtomicCounter {
    private final AsyncAtomicCounter asyncCounter;
    private final long operationTimeoutMillis;

    public BlockingAtomicCounter(AsyncAtomicCounter asyncCounter, long operationTimeoutMillis) {
        super((AsyncPrimitive)asyncCounter);
        this.asyncCounter = asyncCounter;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public long incrementAndGet() {
        return this.complete(this.asyncCounter.incrementAndGet());
    }

    @Override
    public long decrementAndGet() {
        return this.complete(this.asyncCounter.decrementAndGet());
    }

    @Override
    public long getAndIncrement() {
        return this.complete(this.asyncCounter.getAndIncrement());
    }

    @Override
    public long getAndDecrement() {
        return this.complete(this.asyncCounter.getAndDecrement());
    }

    @Override
    public long getAndAdd(long delta) {
        return this.complete(this.asyncCounter.getAndAdd(delta));
    }

    @Override
    public long addAndGet(long delta) {
        return this.complete(this.asyncCounter.addAndGet(delta));
    }

    @Override
    public void set(long value) {
        this.complete(this.asyncCounter.set(value));
    }

    @Override
    public boolean compareAndSet(long expectedValue, long updateValue) {
        return this.complete(this.asyncCounter.compareAndSet(expectedValue, updateValue));
    }

    @Override
    public long get() {
        return this.complete(this.asyncCounter.get());
    }

    @Override
    public AsyncAtomicCounter async() {
        return this.asyncCounter;
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PrimitiveException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new PrimitiveException.Timeout();
        }
        catch (ExecutionException e) {
            throw new PrimitiveException(e.getCause());
        }
    }
}

