/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.counter.impl;

import io.atomix.core.counter.AsyncDistributedCounter;
import io.atomix.core.counter.DistributedCounter;
import io.atomix.core.counter.DistributedCounterBuilder;
import io.atomix.core.counter.DistributedCounterConfig;
import io.atomix.core.counter.impl.AtomicCounterProxy;
import io.atomix.core.counter.impl.AtomicCounterService;
import io.atomix.core.counter.impl.DelegatingDistributedCounter;
import io.atomix.core.counter.impl.GossipDistributedCounter;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.protocol.GossipProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.ProxyProtocol;
import io.atomix.primitive.protocol.counter.CounterProtocol;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.config.ConfigurationException;
import java.util.concurrent.CompletableFuture;

public class DefaultDistributedCounterBuilder
extends DistributedCounterBuilder {
    public DefaultDistributedCounterBuilder(String name, DistributedCounterConfig config, PrimitiveManagementService managementService) {
        super(name, config, managementService);
    }

    public CompletableFuture<DistributedCounter> buildAsync() {
        PrimitiveProtocol protocol = this.protocol();
        if (protocol instanceof GossipProtocol) {
            if (protocol instanceof CounterProtocol) {
                return this.managementService.getPrimitiveCache().getPrimitive(this.name, () -> CompletableFuture.completedFuture(new GossipDistributedCounter(this.name, (GossipProtocol)protocol, ((CounterProtocol)protocol).newCounterDelegate(this.name, this.managementService)))).thenApply(AsyncDistributedCounter::sync);
            }
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException("Counter is not supported by the provided gossip protocol"));
        }
        if (protocol instanceof ProxyProtocol) {
            return ((CompletableFuture)((CompletableFuture)this.newProxy(AtomicCounterService.class, new ServiceConfig()).thenCompose(proxy -> new AtomicCounterProxy((ProxyClient<AtomicCounterService>)proxy, this.managementService.getPrimitiveRegistry()).connect())).thenApply(DelegatingDistributedCounter::new)).thenApply(AsyncDistributedCounter::sync);
        }
        return Futures.exceptionalFuture((Throwable)new ConfigurationException("Invalid protocol type"));
    }
}

