/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.set.impl;

import io.atomix.core.set.AsyncDistributedSortedSet;
import io.atomix.core.set.DistributedSortedSet;
import io.atomix.core.set.impl.BlockingDistributedSet;
import java.util.Comparator;
import java.util.SortedSet;

public class BlockingDistributedSortedSet<E extends Comparable<E>>
extends BlockingDistributedSet<E>
implements DistributedSortedSet<E> {
    private final long operationTimeoutMillis;
    private final AsyncDistributedSortedSet<E> asyncSet;

    public BlockingDistributedSortedSet(AsyncDistributedSortedSet<E> asyncSet, long operationTimeoutMillis) {
        super(asyncSet, operationTimeoutMillis);
        this.asyncSet = asyncSet;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public Comparator<? super E> comparator() {
        return null;
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return new BlockingDistributedSortedSet<E>(this.asyncSet.subSet(fromElement, toElement), this.operationTimeoutMillis);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return new BlockingDistributedSortedSet<E>(this.asyncSet.headSet(toElement), this.operationTimeoutMillis);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return new BlockingDistributedSortedSet<E>(this.asyncSet.tailSet(fromElement), this.operationTimeoutMillis);
    }

    @Override
    public E first() {
        return (E)((Comparable)this.complete(this.asyncSet.first()));
    }

    @Override
    public E last() {
        return (E)((Comparable)this.complete(this.asyncSet.last()));
    }

    @Override
    public AsyncDistributedSortedSet<E> async() {
        return this.asyncSet;
    }
}

